/*
 *	Graph class v1.0
 *	Copyright (C) 2007 by Karol Kozłowski
 *	
 */

#include <graph.h>

#include <iostream>
#include <fstream>


using namespace std;

graph::graph(string filename) {

	ifstream file;
	
	file.open(filename.c_str());				// otwórz plik
	
	if (!file) {								// bład otwarcia pliku 
		cerr << "could not open the file!" << endl;
		exit(1);
	}
	
	file >> numVertex;							// wczytaj liczbę wierzchołków
	file >> numJoints;							// wczytaj liczbę połączeń

	links = new int*[numVertex];

	for (int i=0; i<numVertex; i++)
		links[i]= new int [numVertex];

	for (int i=0; i<numVertex; i++)
		for (int j=0; j<numVertex; j++)
			links[i][j] = (i==j) ? 0 : INT_MAX;	// ustaw wagi wszystkich połączeń na max

	int a,b,w;
	for (int i=0; i<numJoints; i++) {
		file >> a;								// wczytaj wierzchołek a
		file >> b;								// wczytaj wierzchołek b
		file >> w;								// wczytaj wagę pomiędzy wierzchołkami a i b
		links[a-1][b-1]=w;
	}

	file.close();
	
}

graph::graph(graph *g) {	
	
	//cout << "kopiujecie? ...kopiujemy! ...kopiują..." << endl;
	
	numVertex = g->numVertex;					// wczytaj liczbę wierzchołków
	numJoints = g->numJoints;					// wczytaj liczbę połączeń

	links = new int*[numVertex];

	for (int i=0; i<numVertex; i++)
		links[i]= new int [numVertex];

	for (int i=0; i<numVertex; i++)
		for (int j=0; j<numVertex; j++)
			links[i][j] = g->links[i][j];		// skopiuj wagi połączeń
	
}

graph::graph(int nVertex, int nJoints, int initial) {
	
	numVertex = nVertex;						// wczytaj liczbę wierzchołków
	numJoints = nJoints;						// wczytaj liczbę połączeń
	
	links = new int*[numVertex];

	for (int i=0; i<numVertex; i++)
		links[i]= new int [numVertex];

	for (int i=0; i<numVertex; i++)
		for (int j=0; j<numVertex; j++)
			links[i][j] = initial;
}

graph::~graph() {

	if (*links) delete [] *links;
	links = NULL;

}
