#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <fstream>
#include <cstdlib>
#include <vector>
#include <sys/time.h> 


using namespace std;
//---------------------------------------------------------------------------

class Neh{
	private:
		//int n, m;	//liczba zadan, liczba maszyn
		int **d;	//tablica przechowujaca czasy wykonania zadan na maszynach
					//d[k][i] - czas wykonania k-tego zadania na i-tej maszynie
	public:
		int n, m;	//liczba zadan, liczba maszyn
		Neh(string name, int i);
		~Neh();		//algorytm NEH, zwraca C_max
		int neh();
		void printd();
		double i_count;
		int cmax(int i, int j);
};

	Neh::Neh(string name, int i){
		i_count = 0;
		ifstream input;
		input.open(name.c_str());
		input >> n;
		input >> m;
		m = i;
		d = new int *[n+1];
		for (int i = 0; i < n+1; i ++)
			d[i] = new int [m+1];
		
		for (int i=1; i < n+1; i++)
			for (int j=1; j < m+1; j++)
				input >> d[i][j];

		for (int i=0; i<n+1; i++) d[i][0] = 0;
		for (int i=0; i<m+1; i++) d[0][i] = 0;
		input.close();
	}
	
	Neh::~Neh(){
		for (int i=0; i<n+1; i++) 
			if (d[i]) delete [] d[i];		
		if (d) delete [] d;
	}
	
	void Neh::printd(){
		cout << endl;
		for (int i = 0; i < n+1; i++)
		{
			for (int j = 0; j < m+1; j++)
				cout << d[i][j] << "\t";
			cout << endl;
		}
	}
	
	struct para{
		int val;
		int key;
	};
	
	int compare(const void *a, const void *b)
	{
		if ( ((para*)a)->val == ((para*)b)->val ) return 0;
		if ( ((para*)a)->val > ((para*)b)->val ) return -1;
		else return 1;
	}

	int Neh::cmax(int i, int j)
	{
		int s1=d[i][1]; //s1- suma pierwszych,
		int cmax=d[i][1]+d[j][1]; //suma pierwszego i drugiego zadania z maszyny 1
		for (int k=2; k<m+1; k++) //for od 1 !!!!!!!!
		{
			s1+=d[i][k];
			if (cmax > s1) cmax+=d[j][k];
			else cmax = s1 + d[j][k];
		}
		return cmax;
	}

	int Neh::neh(){
		
		para omega[n+1];		
		omega[0].key = 0;	omega[0].val = 0;
		for (int i = 1; i < n+1; i++)		//wyznaczenie priorytetow zadan
		{
			omega[i].key = i;
			omega[i].val = 0;
			for (int j = 1; j < m+1; j++) omega[i].val += d[i][j];
		}

		//sortowanie zadan wzgledem malejacych sum czasow wykonania na wszystkich maszynach-----------------------------		
		qsort(omega,n+1,sizeof(para),compare);		
		
		//ustalenie kolejnośći dwoch pierwszych zadan-------------------------------------------------------------------
		int t1 = cmax(omega[0].key,omega[1].key);
		int t2 = cmax(omega[1].key,omega[0].key);

		{ //przepisywanie tablicy d w odpowiedniej kolejnośći-----------------------------------------------------------
		int **temp = new int*[n+1];	for (int i=0; i<n+1; i++) temp[i] = new int[m+1];
		for (int i=0; i<n; i++)
			for (int j=0; j<m+1; j++)
			{
				temp[i+1][j] = d[omega[i].key][j];
			}

		for (int i=0; i<n+1; i++)
			for (int j=0; j<m+1; j++)
			{
				d[i][j] = temp[i][j];
			}
		for (int j=0; j<m+1; j++) d[0][j]=0;
		for (int i=0; i<n+1; i++) delete [] temp[i]; 	delete [] temp;
		}

		int *M = new int[n+1];		//Makespan_i
		for (int i=0; i<n+1; i++) M[i] = 0;

//główny for algorytmu=================================================================================================
		for (int k=3; k<n+1; k++) 
		{
			//deklaracje tablic.....................................................			
			int **e = new int*[k];		for (int i=0; i<k; i++) e[i] = new int[m+1];
			for (int i=0; i<k; i++) e[i][0]=0;	for (int i=0; i<m+1; i++) e[0][i]=0;
			
			int **q = new int*[k+1];	for (int i=0; i<k+1; i++) q[i] = new int[m+2];
			
			for (int i=0; i<k+1; i++) q[i][m+1]=0;	for (int i=0; i<m+2; i++) q[k][i]=0;
			for (int i=0; i<m+2; i++) q[0][i]=0;
			for (int i=0; i<k+1; i++) q[i][0]=0;

			int **f = new int*[k+1];	for (int i=0; i<k+1; i++) f[i] = new int[m+1];
			for (int i=0; i<k+1; i++) f[i][0]=0;
			for (int i=0; i<m+1; i++) f[0][i]=0;
			//......................................................................

			//krok (1)--------------------------------------------------------------
			for (int i=1; i<k; i++)
				for (int j=1; j<m+1; j++)	e[i][j] = ( e[i][j-1] > e[i-1][j] ? e[i][j-1] : e[i-1][j] ) + d[i][j];

			//krok (2)--------------------------------------------------------------
			for (int i=k-1; i>0; i--)	
				for (int j=m; j>0; j--)		q[i][j] = ( q[i][j+1] > q[i+1][j] ? q[i][j+1] : q[i+1][j] ) + d[i][j];

			//krok (3)--------------------------------------------------------------
			for (int i=1; i<k+1; i++)
				for (int j=1; j<m+1; j++)	f[i][j] = ( f[i][j-1] > e[i-1][j] ? f[i][j-1] : e[i-1][j] ) + d[k][j];

			//krok (4)--------------------------------------------------------------
			int **fplusq = new int*[k+1];	for (int i=0; i<k+1; i++) fplusq[i] = new int[m+1];
			for (int i=0; i<k+1; i++) //dodawanie macierzy f i q
				for (int j=0; j<m+1; j++)	fplusq[i][j] = f[i][j]+q[i][j];
		
			int max = INT_MIN;
			for (int i=1; i<k+1; i++)
			{
				for (int j=1; j<m+1; j++)	if ( fplusq[i][j] > max ) max = fplusq[i][j];
				//cout << endl << "max: " << max << endl;
				M[i]=max;
				max = INT_MIN;
			}
			for (int i=0; i<k+1; i++) delete [] fplusq[i];	delete [] fplusq;

			int min = INT_MAX;
			int imin=-1;
			for (int i=1; i<k+1; i++)	if ( M[i] < min ) { min = M[i]; imin=i; }

			//przestawienie wierszy tablicy d[][]
			int *tempW = new int[m+1];		//kopia wiersza k
			for (int i=0; i<m+1; i++)	tempW[i] = d[k][i];

			for (int i=k-1; i>=imin; i--)
				for (int j=0; j<m+1; j++) d[i+1][j] = d[i][j];

			for (int i=0; i<m+1; i++)	d[imin][i] = tempW[i];
			delete [] tempW;

			//......................................................................
			for (int i=0; i<k+1; i++) delete [] f[i];	delete [] f;
			for (int i=0; i<k+1; i++) delete [] q[i];	delete [] q;
			for (int i=0; i<k; i++) delete [] e[i];		delete [] e;
		}

//=====================================================================================================================

		int min = INT_MAX;
		int imin=-1;
		for (int i=1; i<n+1; i++)	if ( M[i] < min ) { min = M[i]; imin=i; }

		if (M) delete [] M;
		return min;
	}

//---------------------------------------------------------------------------

	int main(int argc, char *argv[])
	{

		string name = argv[1];


		double start, koniec, time, result, n_machines, n_tasks;
		struct timeval tv;

		int j_max = 500;

		for (int i = 3; i < 45; i++) {

			time = 0;
 
			for (int j = 0; j < j_max; j++) {
				gettimeofday(&tv, NULL); 
				start=tv.tv_usec;
		
				Neh ob(name,i);
	
				gettimeofday(&tv, NULL); 
				koniec=tv.tv_usec;
	
				time += (koniec - start);
				//cout << j << " - " << (koniec - start) << endl;
				result = ob.neh();
				n_machines = ob.m;
				n_tasks = ob.n;
			}
			
			cout << n_machines << "; " << time/j_max << endl;
		}
		//cout << endl << "Wyniczek: " << result << endl;
	
		//cout << endl << "Średni czas wykonywania programu: " << time/j_max << endl; 
		
		//cout << n_tasks << "; " << n_machines << "; " << time/j_max << endl;		
		return EXIT_SUCCESS;
	}
