%R - metoda Rosenbrocka z dyskretnym krokiem probnym
close
clear x y z;
% ***********************************
% PARAMETRY DLA METODY R

% global x0 S t b e a d

% parametry startowe
rload;
%x0=[3 0];		 x0 - punkt startowy (wektor o wymiarze S)
S=size(x0,2);	       % S  - liczba zmiennych niezaleznych
%e=0.1;			 e  - wymagana dokladnosc obliczen
d=[[1 0];[0 1]];       % d  - baza kierunkow ortogonalnych


% ***********************************
% interfejs graficzny
% ***********************************

okno2=figure(...
	'Name','Metody poszukiwa prostych - Rosenbrocka',...
	'Units','normalized',...
	'NumberTitle','off','Resize','on','MenuBar','none',...
	'Colormap',mapa_kolorow,'Position',[0.02 0.071 0.96 0.88],...
	'Pointer','arrow');



% przyciski: parametry, oblicz, koniec

uicontrol('style','pushbutton','Units','normalized','position',[0.023 .43 0.36 0.05],...
	'string','Oblicz','CallBack','r01a');
uicontrol('style','pushbutton','Units','normalized','position',[0.899 0 0.1 0.04],...
	'string','Zamknij','callback','rsave;close all;clear;tytulowa');


opcja1=uimenu('Label','P&lik');		% opcja w menu glownym
uimenu(opcja1,'Label','&Otwrz','CallBack','r04');
uimenu(opcja1,'Label','&Zapisz jako ...','CallBack','r05');
uimenu(opcja1,'Label','&Drukuj','CallBack','drukuj','separator','on');
uimenu(opcja1,'Label','Zam&knij','CallBack','close all;clear;tytulowa','separator','on');
if (r_kroku==1),
	temp='off';
else
	temp='on';
end
opcja2=uimenu('Label','Minimalizacja w kierunku','Enable',temp);
opcja21=uimenu(opcja2,'Label','Metoda podziau na p','CallBack','rmet_m1','Checked','on');
opcja22=uimenu(opcja2,'Label','Metoda zotego podziau','CallBack','rmet_m2');
opcja23=uimenu(opcja2,'Label','Metoda aproksymacji kwadratowej','CallBack','rmet_m3','enable','on');
opcja24=uimenu(opcja2,'Label','Metoda dychotomicznego podziau','CallBack','rmet_m4');
uimenu(opcja2,'label','Parametry','Separator','on','Callback','rdlodci');

opcja3=uimenu('Label','&Pomoc','CallBack','helpr');


uklad1=axes('position',[.45 .4 .5 .5],...
            'FontName','Times',...
	    'FontSize',8,...
	    'ButtonDownFcn','',...
	    'Visible','on',...
	    'GridLineStyle',':',...
	    'NextPlot','add',...
            'Interruptible','no');



uklad3=axes('Units','normalized','Position',[0.13 0.11 0.775 0.815],...
            'FontName','Times',...
	    'FontSize',8,...
            'DrawMode','normal',...
            'Visible','off',...
            'ButtonDownFcn','',...
	    'NextPlot','add',...
            'Interruptible','no');

axes(uklad1);
grid on;
axes(uklad3);
grid off;

naglowek=text;
	set(naglowek,'String','Metoda Rosenbrocka z dyskretnym krokiem','Color','y',...
	'FontWeight','bold','FontName','times','FontSize',12,'units','normalized',...
     	'position',[0.47 1.016]);


hjt=.95;
hjtk=0.061;
ods_sym=0.105;
text_p=text;
	set(text_p,'Units','normalized');	set(text_p,'string','Parametry startowe:');
	set(text_p,'FontName','Times');		set(text_p,'FontWeight','bold');
	set(text_p,'color','y');		set(text_p,'FontSize',12);
	set(text_p,'position',[-.14 1.03]);
text_0a=text;
	set(text_0a,'Units','normalized');	set(text_0a,'string','Funkcja celu:');
	set(text_0a,'FontName','Times');	set(text_0a,'color','w');
	set(text_0a,'FontWeight','normal');	set(text_0a,'FontSize',11);
	set(text_0a,'position',[-.14 hjt]);
text_1=text;
	set(text_1,'Units','normalized');	set(text_1,'string','Punkt startowy           x0 :=');
	set(text_1,'FontName','Times');		set(text_1,'color','w');
	set(text_1,'FontWeight','normal');	set(text_1,'FontSize',11);
	set(text_1,'position',[-.14 0.83]);
text_6=text;
	set(text_6,'Units','normalized');	set(text_6,'string','Dokadno oblicze        :=');
	set(text_6,'FontName','Times');		set(text_6,'color','w');
	set(text_6,'FontWeight','normal');	set(text_6,'FontSize',11);
	set(text_6,'position',[-.14 hjt-4.6*hjtk+0.1]);
text_7=text;
	set(text_7,'Units','normalized');	set(text_7,'string','e');
	set(text_7,'FontName','symbol');	set(text_7,'color','w');
	set(text_7,'FontWeight','normal');	set(text_7,'FontSize',16);
	set(text_7,'position',[ods_sym hjt-4.6*hjtk+0.105]);
text_8=text;
	set(text_8,'Units','normalized');	set(text_8,'string','Wsp. zmiany kierunku      :=');
	set(text_8,'FontName','Times');		set(text_8,'color','w');
	set(text_8,'FontWeight','normal');	set(text_8,'FontSize',11);
	set(text_8,'position',[-.14 hjt-5.55*hjtk+0.1]);
text_9=text;
	set(text_9,'Units','normalized');	set(text_9,'string','b');
	set(text_9,'FontName','symbol');	set(text_9,'color','w');
	set(text_9,'FontWeight','normal');	set(text_9,'FontSize',16);
	set(text_9,'position',[ods_sym hjt-5.55*hjtk+0.105]);
text_10=text;
	set(text_10,'Units','normalized');	set(text_10,'string','Metoda Rosenbrocka z                        krokiem');
	set(text_10,'FontName','Times');	set(text_10,'color','w');
	set(text_10,'FontWeight','normal');	set(text_10,'FontSize',11);
	set(text_10,'position',[-.14 hjt-7.5*hjtk]);
text_3=text;
	set(text_3,'Units','normalized');	set(text_3,'string','Wsp. kroku                     :=');
	set(text_3,'FontName','Times');		set(text_3,'color','w');
	set(text_3,'FontWeight','normal');	set(text_3,'FontSize',11);
	set(text_3,'position',[-.14 hjt-6.45*hjtk+0.1]);
text_2=text;
	set(text_2,'Units','normalized');	set(text_2,'string','t');
	set(text_2,'FontName','Symbol');	set(text_2,'color','w');
	set(text_2,'FontWeight','normal');	set(text_2,'FontSize',16);
	set(text_2,'position',[ods_sym hjt-6.45*hjtk+0.105]);
text_4=text;
	set(text_4,'Units','normalized');	set(text_4,'string','Wsp. zwik. kroku           :=');
	set(text_4,'FontName','Times');		set(text_4,'color','w');
	set(text_4,'FontWeight','normal');	set(text_4,'FontSize',11);
	set(text_4,'position',[-.14 hjt-7.35*hjtk+0.1]);
text_5=text;
	set(text_5,'Units','normalized');	set(text_5,'string','a');
	set(text_5,'FontName','Symbol');	set(text_5,'color','w');
	set(text_5,'FontWeight','normal');	set(text_5,'FontSize',16);
	set(text_5,'position',[ods_sym hjt-7.35*hjtk+0.105]);

text_w=text;
	set(text_w,'Units','normalized');	set(text_w,'string','Wyniki oblicze:');
	set(text_w,'FontName','Times');		set(text_w,'FontWeight','bold');
	set(text_w,'color','y');		set(text_w,'FontSize',12);
	set(text_w,'position',[-.14 hjt-9.6*hjtk]);
text_21=text;
	set(text_21,'Units','normalized');	set(text_21,'string','Kryterium stopu:');
	set(text_21,'FontName','Times');	set(text_21,'FontWeight','normal');
	set(text_21,'color','w');		set(text_21,'FontSize',11);
	set(text_21,'position',[-.14 0.55]);	set(text_21,'visible','on');



% **********
% x0 *******************************************************
% **********
t1=uicontrol('style','edit','Units','normalized','position',[0.26 0.766 0.118 0.035],...
	'backgroundcolor','w','Foregroundcolor','b','string',['[',num2str(x0(1)),' ',num2str(x0(2)),']'],'CallBack','r06');
% **********
% a *******************************************************
% **********
t2=uicontrol('style','edit','Units','normalized','position',[0.26 0.583 0.09 0.035],...
	'backgroundcolor','w','Foregroundcolor','b','string',num2str(a),'CallBack','r06');
s2=uicontrol('style','slider','Units','normalized','Position',[0.35 0.583 0.03 0.035],...
	'CallBack','r07','min',1,'max',10);
set(s2,'value',str2num(get(t2,'string')));
% **********
% e *******************************************************
% **********
t4=uicontrol('style','edit','Units','normalized','position',[0.26 0.718 0.09 0.035],...
	'backgroundcolor','w','string',num2str(e),'CallBack','r06');
s4=uicontrol('style','slider','Units','normalized','Position',[0.35 0.718 0.03 0.035],...
	'CallBack','r07','max',1);
set(s4,'value',str2num(get(t4,'string')));
% **********
% b *******************************************************
% **********
t5=uicontrol('style','edit','Units','normalized','position',[0.26 0.672 0.09 0.035],...
	'backgroundcolor','w','string',num2str(b),'CallBack','r06');
s5=uicontrol('style','slider','Units','normalized','Position',[0.35 0.672 0.03 0.035],...
	'CallBack','r07','min',-1,'max',0);
set(s5,'value',str2num(get(t5,'string')));
% **********
% rodzaj kroku prbnego ***********************************
% **********
s6=uicontrol('style','popupmenu','units','normalized','position',[0.21 0.492 0.12 0.035],...
	'string','dyskretnym|optymalnym','backgroundcolor','w',...
	'callback','r01b','value',r_kroku);	% aktywacja odpowiednik parametrw
% **********
% t *******************************************************
% **********
t3=uicontrol('style','edit','Units','normalized','position',[0.26 0.627 0.118 0.035],...
	'backgroundcolor','w','string',['[',num2str(t(1)),' ',num2str(t(2)),']'],'CallBack','r06');

% **********
% funkcja celu ********************************************
% **********
s7=uicontrol('style','popupmenu','units','normalized','position',[0.14 0.865 0.24 0.035],...
	'string','axx+byy+cxy+dx+ey+f|Bananoida|axx+byy+csin(xx)+dcos(yy)|(ax-b)^c+(dy-e)^f|Testowa|[x-a]/b+[y-c]/d',...
	'backgroundcolor','w','callback','r11,r06');
set(s7,'value',funkcjanr);
% **********
% kryterium stopu ********************************************
% **********
s8=uicontrol('style','popupmenu','units','normalized','position',[0.157 0.538 0.223 0.035],...
	'string','Q1=norm(xn+1-xn)<e|Q2=norm(f(xn+1)-f(xn))<e|Q3=Q2/Q1',...
	'backgroundcolor','w','visible','on');

uicontrol('style','pushbutton','units','normalized','position',[0.346 0.82 0.032 0.032],...
	'string','P','callback','r12');

%rozwizanie
text_11=text(-0.11,0.31,'','FontName','Times','FontSize',10,...
	'color','c','fontweight','bold','visible','on');

% parametry funkcji celu - wyswietlenie
text_13=text;
	set(text_13,'Units','normalized');	
	set(text_13,'FontName','Times');	set(text_13,'color','w');
	set(text_13,'FontWeight','normal');	set(text_13,'FontSize',10);
	set(text_13,'position',[-.14 0.889]);
	if (get(s7,'value')==1),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3)),', d=',num2str(par(4)),', e=',num2str(par(5)),', f=',num2str(par(6))]);
	elseif (get(s7,'value')==2),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3))]);
	elseif (get(s7,'value')==3),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3)),', d=',num2str(par(4))]);
	elseif (get(s7,'value')==4),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3)),', d=',num2str(par(4)),', e=',num2str(par(5)),', f=',num2str(par(6))]);
	elseif (get(s7,'value')==5),
		set(text_13,'string','funkcja testowa: (x-2)^4+(x-2y)^2');
	elseif (get(s7,'value')==6),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3)),', d=',num2str(par(4))]);
	end

r01b;