% a,b - badany przedzial
% k - calkowita ilosc iteracji po ktorych algorytm zakonczy dzialanie
% z - wektor zmiennych pomocniczych z metody R
% d - wektor kierunkow ortogonalnych z metody R
% s - nr jierunku
% n - aktualny nr wykonywanej iteracji

function [minf,iter]=nspolb(a,b,k,z,d,s,n,funkcjanr,par)
	ln=0.5*(a+b);
	if (abs(nspochod(z,d,s,funkcjanr,ln,par))<1e-6),
		minf=[ln ln];
		iter=n*2;
		return;
	else
		ap=a;
		bp=b;
		if (nspochod(z,d,s,funkcjanr,ln,par)>0),
			% a - bez zmian
			b=ln;
		else
			a=ln;
			% b - bez zmian
		end
		if (k==n),
			minf=[a b];
			iter=n;
			return;
		else
			[minf iter]=nspolb(a,b,k,z,d,s,n+1,funkcjanr,par);

		end
			
	end