%NS - metoda Najwiekszego Spadku
close
global funkcjanr;
% ***********************************
% PARAMETRY DLA METODY NS
clear x y z;


% parametry startowe
nsload;
%x0=[3 0];		 x0 - punkt startowy (wektor o wymiarze S)
S=size(x0,2);	       % S  - liczba zmiennych niezaleznych
%H			macierz drugich pochodnych
%gr			gradient funkcji w punkcie
%e=0.1;			 e  - wymagana dokladnosc obliczen


% ***********************************
% interfejs graficzny
% ***********************************

okno2=figure(...
	'Name','Metody podstawowych kierunkw poprawy funkcji bez ogranicze - Metody gradientowe proste',...
	'Units','normalized',...
	'NumberTitle','off','Resize','on','MenuBar','none',...
	'Colormap',mapa_kolorow,'Position',[0.02 0.071 0.96 0.88],...
	'Pointer','arrow');



% przyciski: parametry, oblicz, koniec

uicontrol('style','pushbutton','Units','normalized','position',[0.023 .43 0.36 0.05],...
	'string','Oblicz','CallBack','ns02');
uicontrol('style','pushbutton','Units','normalized','position',[0.899 0 0.1 0.04],...
	'string','Zamknij','callback','nssave;close all;clear;tytulowa');


opcja1=uimenu('Label','P&lik');		% opcja w menu glownym
opcja11=uimenu(opcja1,'Label','&Otwrz','CallBack','ns04;');
opcja12=uimenu(opcja1,'Label','&Zapisz jako ...','CallBack','ns05');
opcja13=uimenu(opcja1,'Label','Zmie &cig','Callback','nsciag','separator','on');
opcja14=uimenu(opcja1,'Label','&Drukuj','CallBack','drukuj','separator','on');
opcja15=uimenu(opcja1,'Label','Zam&knij','CallBack','close all;clear;tytulowa','separator','on');
opcja2=uimenu('Label','Minimalizacja w kierunku');
opcja21=uimenu(opcja2,'Label','Metoda podziau na p','CallBack','nsmet_m1','Checked','on');
opcja22=uimenu(opcja2,'Label','Metoda zotego podziau','CallBack','nsmet_m2');
opcja23=uimenu(opcja2,'Label','Metoda aproksymacji kwadratowej','CallBack','nsmet_m3','enable','on');
opcja24=uimenu(opcja2,'Label','Metoda dychotomicznego podziau','CallBack','nsmet_m4');
opcja25=uimenu(opcja2,'Label','Metoda Newtona','CallBack','nsmet_m5');
opcja26=uimenu(opcja2,'label','Parametry','Separator','on','Callback','nsdlodci');
opcja3=uimenu('Label','&Pomoc','CallBack','helpns');


uklad1=axes('position',[.45 .4 .5 .5],...
            'FontName','Times',...
	    'FontSize',8,...
	    'ButtonDownFcn','',...
	    'Visible','on',...
	    'GridLineStyle',':',...
	    'NextPlot','add',...
            'Interruptible','no');



uklad3=axes('Units','normalized','Position',[0.13 0.11 0.775 0.815],...
            'FontName','Times',...
	    'FontSize',8,...
            'DrawMode','normal',...
            'Visible','off',...
            'ButtonDownFcn','',...
	    'NextPlot','add',...
            'Interruptible','no');

axes(uklad1);
grid on;
axes(uklad3);
grid off;

naglowek=text;
	set(naglowek,'String','Metoda Najwikszego Spadku','Color','y',...
	'FontWeight','bold','FontName','times','FontSize',12,'units','normalized',...
     	'position',[0.55 1.016]);


hjt=.95;
hjtk=0.061;
ods_sym=0.105;
text_p=text;
	set(text_p,'Units','normalized');	set(text_p,'string','Parametry startowe:');
	set(text_p,'FontName','Times');		set(text_p,'FontWeight','bold');
	set(text_p,'color','y');		set(text_p,'FontSize',12);
	set(text_p,'position',[-.14 1.03]);
text_0a=text;
	set(text_0a,'Units','normalized');	set(text_0a,'string','Funkcja celu:');
	set(text_0a,'FontName','Times');	set(text_0a,'color','w');
	set(text_0a,'FontWeight','normal');	set(text_0a,'FontSize',11);
	set(text_0a,'position',[-.14 hjt]);
text_1=text;
	set(text_1,'Units','normalized');	set(text_1,'string','Punkt startowy            x0  :=');
	set(text_1,'FontName','Times');		set(text_1,'color','w');
	set(text_1,'FontWeight','normal');	set(text_1,'FontSize',11);
	set(text_1,'position',[-.14 hjt-2*hjtk]);
text_6=text;
	set(text_6,'Units','normalized');	set(text_6,'string','Dokadno oblicze        :=');
	set(text_6,'FontName','Times');		set(text_6,'color','w');
	set(text_6,'FontWeight','normal');	set(text_6,'FontSize',11);
	set(text_6,'position',[-.14 hjt-3*hjtk]);
text_2=text;
	set(text_2,'Units','normalized');	set(text_2,'string','Parametr cigu                  :=');
	set(text_2,'FontName','Times');		set(text_2,'color','w');
	set(text_2,'FontWeight','normal');	set(text_2,'FontSize',11);
	set(text_2,'position',[-.14 hjt-4*hjtk]);
text_3=text;
	set(text_3,'Units','normalized');	set(text_3,'string','a');
	set(text_3,'FontName','symbol');	set(text_3,'color','w');
	set(text_3,'FontWeight','normal');	set(text_3,'FontSize',16);
	set(text_3,'position',[ods_sym-0.005 hjt-4*hjtk+0.005]);
if r_M==1,
	set(text_2,'visible','on');
	set(text_3,'visible','on');

else
	set(text_2,'visible','off');
	set(text_3,'visible','off');
end

text_7=text;
	set(text_7,'Units','normalized');	set(text_7,'string','e');
	set(text_7,'FontName','symbol');	set(text_7,'color','w');
	set(text_7,'FontWeight','normal');	set(text_7,'FontSize',16);
	set(text_7,'position',[ods_sym hjt-3*hjtk+0.005]);


text_21=text;
	set(text_21,'Units','normalized');	set(text_21,'string','Kryterium stopu:');
	set(text_21,'FontName','Times');		set(text_21,'FontWeight','normal');
	set(text_21,'color','w');		set(text_21,'FontSize',11);
	set(text_21,'position',[-.14 hjt-5*hjtk]);	set(text_21,'visible','on');

text_5=text;
	set(text_5,'Units','normalized');	set(text_5,'string','Gradient obliczany');
	set(text_5,'FontName','Times');		set(text_5,'color','w');
	set(text_5,'FontWeight','normal');	set(text_5,'FontSize',11);
	set(text_5,'position',[-.14 hjt-6*hjtk]);	

text_8=text;
	set(text_8,'Units','normalized');	set(text_8,'string','Metoda:');
	set(text_8,'FontName','Times');		set(text_8,'color','w');
	set(text_8,'FontWeight','normal');	set(text_8,'FontSize',11);
	set(text_8,'position',[-.14 hjt-7*hjtk]);	


text_w=text;
	set(text_w,'Units','normalized');	set(text_w,'string','Wyniki oblicze:');
	set(text_w,'FontName','Times');		set(text_w,'FontWeight','bold');
	set(text_w,'color','y');		set(text_w,'FontSize',12);
	set(text_w,'position',[-.14 hjt-9.6*hjtk]);


% **********
% x0 *******************************************************
% **********
t1=uicontrol('style','edit','Units','normalized','position',[0.26 0.765 0.118 0.035],...
	'backgroundcolor','w','Foregroundcolor','b','string',['[',num2str(x0(1)),' ',num2str(x0(2)),']'],'CallBack','ns06');
% **********
% e *******************************************************
% **********
t4=uicontrol('style','edit','Units','normalized','position',[0.26 0.718 0.09 0.035],...
	'backgroundcolor','w','string',num2str(e),'CallBack','ns06');
s4=uicontrol('style','slider','Units','normalized','Position',[0.35 0.718 0.03 0.035],...
	'CallBack','ns07','Max',0.1,'Min',0.0001);
set(s4,'value',str2num(get(t4,'string')));
% **********
% parametr ciagu alfa *******************************************************
% **********
t5=uicontrol('style','edit','Units','normalized','position',[0.26 0.671 0.09 0.035],...
	'backgroundcolor','w','string',num2str(alfa),'CallBack','ns06');
s5=uicontrol('style','slider','Units','normalized','Position',[0.35 0.671 0.03 0.035],...
	'CallBack','ns07','Max',10,'Min',0.001);
if r_M==1,
	set(t5,'visible','on');
	set(s5,'visible','on');
else
	set(t5,'visible','off');
	set(s5,'visible','off');
end
% **********
% sposob obliczania gradientu ********
% **********
s6=uicontrol('style','popupmenu','units','normalized','position',[0.253 0.571 0.127 0.035],...
	'string','numerycznie|z wzorw','backgroundcolor','w','CallBack','ns06');
set(s6,'value',r_G);
% **********
% funkcja celu ********************************************
% **********
s7=uicontrol('style','popupmenu','units','normalized','position',[0.14 0.865 0.24 0.035],...
	'string','axx+byy+cxy+dx+ey+f|Bananoida|axx+byy+csin(xx)+dcos(yy)|(ax-b)^c+(dy-e)^f|Testowa',...
	'backgroundcolor','w','Callback','ns11,ns06');
set(s7,'value',funkcjanr);
% **********
% kryterium stopu ********************************************
% **********
s8=uicontrol('style','popupmenu','units','normalized','position',[0.157 0.618 0.223 0.035],...
	'string','Q1=norm(xn+1-xn)<e|Q2=norm(f(xn+1)-f(xn))<e|Q3=Q2/Q1|Q4=grad(x)<e',...
	'backgroundcolor','w','visible','on','CallBack','ns06');
set(s8,'value',r_Q);
% **********
% rodzaj metody ********************************************
% **********
s9=uicontrol('style','popupmenu','units','normalized','position',[0.17 0.52 0.211 0.035],...
	'string','gradientu prostego|najwikszego spadku','backgroundcolor','w','visible','on','CallBack','ns06');
set(s9,'value',r_M);
ns06;

uicontrol('style','pushbutton','units','normalized','position',[0.346 0.82 0.032 0.032],...
	'string','P','callback','ns12');

%rozwizanie
text_11=text(-0.11,0.31,'','FontName','Times','FontSize',10,...
	'color','c','fontweight','bold','visible','on');

% parametry funkcji celu - wyswietlenie
text_13=text;
	set(text_13,'Units','normalized');	
	set(text_13,'FontName','Times');	set(text_13,'color','w');
	set(text_13,'FontWeight','normal');	set(text_13,'FontSize',10);
	set(text_13,'position',[-.14 0.889]);
	if (get(s7,'value')==1),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3)),', d=',num2str(par(4)),', e=',num2str(par(5)),', f=',num2str(par(6))]);
	elseif (get(s7,'value')==2),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3))]);
	elseif (get(s7,'value')==3),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3)),', d=',num2str(par(4))]);
	elseif (get(s7,'value')==4),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3)),', d=',num2str(par(4)),', e=',num2str(par(5)),', f=',num2str(par(6))]);
	elseif (get(s7,'value')==5),
		set(text_13,'string','funkcja testowa: (x-2)^4+(x-2y)^2');
	elseif (get(s7,'value')==6),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3)),', d=',num2str(par(4))]);
	end


ns06;
%algorytm Newtona
