%NM - metoda sympleksu Neldera i Meada
close
% ***********************************
% PARAMETRY DLA METODY HJ
clear x y z;
% global x0 S t b e a d

% parametry startowe
nmload;
%load par_NM
%x0=[3 0;1 2;2 1];	 x0 - punkt startowy (wektor o wymiarze S)
S=size(x0,2);	       % S  - liczba zmiennych niezaleznych
%t=0.2;			 t  - wsp. dlugosci kroku probnego
%b=0.5;			 b  - wspolczynnik korekcji dlugosci kroku t
%e=0.1;			 e  - wymagana dokladnosc obliczen
%a=1;			 a  - wspolczynnik etapu roboczego	
d=[[1 0];[0 1]];       % d  - baza kierunkow ortogonalnych


% ***********************************
% interfejs graficzny
% ***********************************

okno2=figure(...
	'Name','Metody poszukiwa prostych - sympleksu Neldera i Meada',...
	'Units','normalized',...
	'NumberTitle','off','Resize','on','MenuBar','none',...
	'Colormap',mapa_kolorow,'Position',[0.02 0.071 0.96 0.88],...
	'Pointer','arrow');



% przyciski: parametry, oblicz, koniec

uicontrol('style','pushbutton','Units','normalized','position',[0.023 .43 0.36 0.05],...
	'string','Oblicz','CallBack','nm02');
uicontrol('style','pushbutton','Units','normalized','position',[0.899 0 0.1 0.04],...
	'string','Zamknij','callback','nmsave;close all;clear;tytulowa');


opcja1=uimenu('Label','P&lik');		% opcja w menu glownym
uimenu(opcja1,'Label','&Otwrz','CallBack','nm04;');
uimenu(opcja1,'Label','&Zapisz jako ...','CallBack','nm05');
uimenu(opcja1,'Label','&Drukuj','CallBack','drukuj','separator','on');
uimenu(opcja1,'Label','Zam&knij','CallBack','close all;clear;tytulowa','separator','on');
opcja2=uimenu('Label','&Pomoc','CallBack','helpnm');


uklad1=axes('position',[.45 .4 .5 .5],...
            'FontName','Times',...
	    'FontSize',8,...
	    'ButtonDownFcn','',...
	    'Visible','on',...
	    'GridLineStyle',':',...
	    'NextPlot','add',...
            'Interruptible','no');



uklad3=axes('Units','normalized','Position',[0.13 0.11 0.775 0.815],...
            'FontName','Times',...
	    'FontSize',8,...
            'DrawMode','normal',...
            'Visible','off',...
            'ButtonDownFcn','',...
	    'NextPlot','add',...
            'Interruptible','no');

axes(uklad1);
grid on;
axes(uklad3);
grid off;

naglowek=text;
	set(naglowek,'String','Metoda sympleksu Neldera i Meada','Color','y',...
	'FontWeight','bold','FontName','times','FontSize',12,'units','normalized',...
     	'position',[0.5 1.016]);


hjt=.95;
hjtk=0.061;
ods_sym=0.105;
text_p=text;
	set(text_p,'Units','normalized');	
	set(text_p,'string','Parametry startowe:');
	set(text_p,'FontName','Times');		set(text_p,'FontWeight','bold');
	set(text_p,'color','y');		set(text_p,'FontSize',12);
	set(text_p,'position',[-.14 1.03]);
text_0a=text;
	set(text_0a,'Units','normalized');	
	set(text_0a,'string','Funkcja celu:');
	set(text_0a,'FontName','Times');	set(text_0a,'color','w');
	set(text_0a,'FontWeight','normal');	set(text_0a,'FontSize',11);
	set(text_0a,'position',[-.14 hjt]);
text_1=text;
	set(text_1,'Units','normalized');	
	set(text_1,'string','Sympleks startowy    x01 :=');
	set(text_1,'FontName','Times');		set(text_1,'color','w');
	set(text_1,'FontWeight','normal');	set(text_1,'FontSize',11);
	set(text_1,'position',[-.14 hjt-2*hjtk]);
text_1a=text;
	set(text_1a,'Units','normalized');
	set(text_1a,'string','Dugo boku symp.   c  :=');
	set(text_1a,'FontName','Times');		set(text_1a,'color','w');
	set(text_1a,'FontWeight','normal');		set(text_1a,'FontSize',11);
	set(text_1a,'position',[-.14 hjt-2.8*hjtk]);
text_1aa=text;
	set(text_1aa,'Units','normalized');
	set(text_1aa,'string','                               x02 :=');
	set(text_1aa,'FontName','Times');		set(text_1aa,'color','w');
	set(text_1aa,'FontWeight','normal');		set(text_1aa,'FontSize',11);
	set(text_1aa,'visible','off');			set(text_1aa,'position',[-.14 hjt-2.8*hjtk]);
text_1b=text;
	set(text_1b,'Units','normalized');
	set(text_1b,'string','                               x03 :=');
	set(text_1b,'FontName','Times');		set(text_1b,'color','w');
	set(text_1b,'FontWeight','normal');		set(text_1b,'FontSize',11);
	set(text_1b,'Visible','off');			set(text_1b,'position',[-.14 hjt-3.6*hjtk]);
text_2=text;
	set(text_2,'Units','normalized');	
	set(text_2,'string','Wsp. odbicia                   :=');
	set(text_2,'FontName','Times');		set(text_2,'color','w');
	set(text_2,'FontWeight','normal');	set(text_2,'FontSize',11);
	set(text_2,'position',[-.14 hjt-4.5*hjtk]);
text_3=text;
	set(text_3,'Units','normalized');	
	set(text_3,'string','a');
	set(text_3,'FontName','symbol');	set(text_3,'color','w');
	set(text_3,'FontWeight','normal');	set(text_3,'FontSize',16);
	set(text_3,'position',[ods_sym-0.005 hjt-4.5*hjtk+0.005]);
text_4=text;
	set(text_4,'Units','normalized');	
	set(text_4,'string','Wsp. ekspansji                :=');
	set(text_4,'FontName','Times');		set(text_4,'color','w');
	set(text_4,'FontWeight','normal');	set(text_4,'FontSize',11);
	set(text_4,'position',[-.14 hjt-5.5*hjtk]);
text_5=text;
	set(text_5,'Units','normalized');	
	set(text_5,'string','g');
	set(text_5,'FontName','symbol');	set(text_5,'color','w');
	set(text_5,'FontWeight','normal');	set(text_5,'FontSize',16);
	set(text_5,'position',[ods_sym-0.004 hjt-5.5*hjtk+0.005]);
text_6=text;
	set(text_6,'Units','normalized');	
	set(text_6,'string','Wsp. kontrakcji               :=');
	set(text_6,'FontName','Times');		set(text_6,'color','w');
	set(text_6,'FontWeight','normal');	set(text_6,'FontSize',11);
	set(text_6,'position',[-.14 hjt-6.5*hjtk]);
text_7=text;
	set(text_7,'Units','normalized');	
	set(text_7,'string','b');
	set(text_7,'FontName','symbol');	set(text_7,'color','w');
	set(text_7,'FontWeight','normal');	set(text_7,'FontSize',16);
	set(text_7,'position',[ods_sym-0.004 hjt-6.5*hjtk+0.005]);
text_8=text;
	set(text_8,'Units','normalized');	
	set(text_8,'string','Dokadno oblicze       :=');
	set(text_8,'FontName','Times');		set(text_8,'color','w');
	set(text_8,'FontWeight','normal');	set(text_8,'FontSize',11);
	set(text_8,'position',[-.14 hjt-7.5*hjtk]);
text_9=text;
	set(text_9,'Units','normalized');	
	set(text_9,'string','e');		set(text_9,'FontName','symbol');
	set(text_9,'color','w');		set(text_9,'FontWeight','normal');
	set(text_9,'FontSize',16);		
	set(text_9,'position',[ods_sym-0.004 hjt-7.5*hjtk+0.005]);




% **********
% x01,02,03 *******************************************************
% **********
t1_1=uicontrol('style','edit','Units','normalized','position',[0.26 0.766 0.118 0.035],...
	'backgroundcolor','w','Foregroundcolor','b','string',['[',num2str(x0(1,1)),' ',num2str(x0(1,2)),']'],'CallBack','nm06');
t1_2=uicontrol('style','edit','Units','normalized','position',[0.26 0.727 0.118 0.035],...
	'backgroundcolor','w','Foregroundcolor','b','string',['[',num2str(x0(2,1)),' ',num2str(x0(2,2)),']'],'CallBack','nm06',...
	'visible','off');
t1_2a=uicontrol('style','edit','Units','normalized','position',[0.26 0.727 0.118 0.035],...
	'backgroundcolor','w','Foregroundcolor','b','string',num2str(c_sym),'CallBack','nm06');
t1_3=uicontrol('style','edit','Units','normalized','position',[0.26 0.689 0.118 0.035],...
	'backgroundcolor','w','Foregroundcolor','b','string',['[',num2str(x0(3,1)),' ',num2str(x0(3,2)),']'],'CallBack','nm06',...
	'visible','off');

% **********
% a *******************************************************
% **********
t2=uicontrol('style','edit','Units','normalized','position',[0.26 0.644 0.09 0.035],...
	'backgroundcolor','w','string',num2str(a),'CallBack','nm06');
s2=uicontrol('style','slider','Units','normalized','Position',[0.35 0.644 0.03 0.035],...
	'CallBack','nm07','max',5,'min',.001);
set(s2,'value',str2num(get(t2,'string')));
% **********
% g *******************************************************
% **********
t3=uicontrol('style','edit','Units','normalized','position',[0.26 0.594 0.09 0.035],...
	'backgroundcolor','w','string',num2str(g),'CallBack','nm06');
s3=uicontrol('style','slider','Units','normalized','Position',[0.35 0.594 0.03 0.035],...
	'CallBack','nm07','max',5,'min',1.001);
set(s3,'value',str2num(get(t3,'string')));
% **********
% b *******************************************************
% **********
t4=uicontrol('style','edit','Units','normalized','position',[0.26 0.544 0.09 0.035],...
	'backgroundcolor','w','string',num2str(b),'CallBack','nm06');
s4=uicontrol('style','slider','Units','normalized','Position',[0.35 0.544 0.03 0.035],...
	'CallBack','nm07','max',5,'min',0);
set(s4,'value',str2num(get(t4,'string')));
% **********
% e *******************************************************
% **********
t5=uicontrol('style','edit','Units','normalized','position',[0.26 0.494 0.09 0.035],...
	'backgroundcolor','w','string',num2str(e),'CallBack','nm06');
s5=uicontrol('style','slider','Units','normalized','Position',[0.35 0.494 0.03 0.035],...
	'CallBack','nm07','max',1,'min',0.001);
set(s5,'value',str2num(get(t5,'string')));
% **********
% rodzaj wyboru sympleksu startowego *************************
% **********
s6=uicontrol('style','popupmenu','units','normalized','position',[0.025 0.68 0.14 0.035],...
	'string','x01, c|x01, x02, x03','backgroundcolor','w','callback','nm01b');
% **********
% funkcja celu ********************************************
% **********
s7=uicontrol('style','popupmenu','units','normalized','position',[0.14 0.865 0.24 0.035],...
	'string','axx+byy+cxy+dx+ey+f|Bananoida|axx+byy+csin(xx)+dcos(yy)|(ax-b)^c+(dy-e)^f|Testowa|[x-a]/b+[y-c]/d',...
	'backgroundcolor','w','callback','nm11,nm06');
set(s7,'value',funkcjanr);

uicontrol('style','pushbutton','units','normalized','position',[0.346 0.82 0.032 0.032],...
	'string','P','callback','nm12');

%rozwizanie
text_11=text(-0.11,0.31,'','FontName','Times','FontSize',10,...
	'color','c','fontweight','bold','visible','on');

% parametry funkcji celu - wyswietlenie
text_13=text;
	set(text_13,'Units','normalized');	
	set(text_13,'FontName','Times');	set(text_13,'color','w');
	set(text_13,'FontWeight','normal');	set(text_13,'FontSize',10);
	set(text_13,'position',[-.14 0.889]);
	if (get(s7,'value')==1),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3)),', d=',num2str(par(4)),', e=',num2str(par(5)),', f=',num2str(par(6))]);
	elseif (get(s7,'value')==2),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3))]);
	elseif (get(s7,'value')==3),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3)),', d=',num2str(par(4))]);
	elseif (get(s7,'value')==4),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3)),', d=',num2str(par(4)),', e=',num2str(par(5)),', f=',num2str(par(6))]);
	elseif (get(s7,'value')==5),
		set(text_13,'string','funkcja testowa: (x-2)^4+(x-2y)^2');
	elseif (get(s7,'value')==6),
		set(text_13,'string',['a=',num2str(par(1)),', b=',num2str(par(2)),', c=',num2str(par(3)),', d=',num2str(par(4))]);
	end


%algorytm NM