%% Parametry obiektu
TwN = 20;                   %temp. wewn. budynku
TzewN = -20;                %temp. na zewn. budynku
TgzN = 90;                  %temp. wpywajca do grzejnika
TgpN = 70;                  %temp. wypywajca z grzejnika

Cpp = 1000;                 %ciepo waciwe powietrza
Cpw = 4175;                 %ciepo wlaciwe wody
ep = 1.2;                   %gsto powietrza
ew = 1000;                  %gsto wody

Vp = 3 * 4 * 2.3;           %objto pomieszczenia
Vw = 2 * 0.7 *1;            %objto grzejnika
Vk = 1 * 1 * 1;             %objto kota

QN = 5000;                  %ciepo oddawane przez grzejnik
QdN = 0;
PkN = 3 * QN;               %moc kota na 3 pomieszczenia

T0=1000;                    %opnienie 
Tdelay = 1000;

%% warunki pocztkowe (nominalne)
Tzew0=TzewN;
Tgz0=TgzN;
Tkz0=TkzN;
Tkp0=TkpN;

F0 = FN;
Qd0=QdN;
Pk0 = PkN;

%% zakcenia
dTzew0=0;
dTgz0=0;

dF1=0;
dF2=0;
dF3=0;

dQd1=0;
dQd2=500;
dQd3=0;

dPk0=0;

%% Obliczenia dla wartoci nominalnych
cvg=Cpw*ew*Vw;           %pojemno pieplna grzejnika
cvw=Cpp*ep*Vp;           %pojemno pieplna pokoju
cvk=Cpw*ew*Vk;           %pojemno pieplna kota

TgsrN = (TgzN + TgpN) / 2;
TgpN = 2 * TgsrN - TgzN;
TkpN=TgpN;
TkzN=TgzN;
FN = QN / (2 * Cpw * ew * (TgzN - TgsrN));
FkN = 3 * FN;
kg = QN / (TgsrN - TwN);
kstr = (QN + QdN) / (TwN - TzewN);

%% Obliczenia cd.
Tgsr0 = ( 2 * Cpw * ew * F0 * Tgz0 * (kg + kstr) + kg * (kstr*Tzew0 + Qd0) ) / ( kg * kstr + 2 * Cpw * ew * F0 * (kg + kstr) );
Tw0 = (Qd0 + kg * Tgsr0 + kstr * Tzew0) / (kg + kstr);



