% Metody poszukiwania minimum w kierunku
close

if exist('mapa_kolorow')==0 load dane; end; %ladowanie palety kolorow

zzload;
% ***********************************
% interfejs graficzny
% ***********************************
okno2=figure(...
    	'ButtonDownFcn','',...
	'Name','Metody poszukiwa minimum w kierunku',...
	'Units','normalized',...
	'NumberTitle','off','Resize','on','MenuBar','none',...
	'Colormap',mapa_kolorow,'Position',[0.001 0.05 0.998 0.93],...
	'Pointer','arrow');

% *******************************
% ****** ZAKONCZ ****************
% *******************************
uicontrol('style','pushbutton','Units','normalized','position',[0.899 0 0.1 0.04],...
	'string','Zamknij','callback','close all;clear;tytulowa');

% *******************************
% ***** MENU ********************
% *******************************
opcja1=uimenu('Label','P&arametry');		% opcja w menu glownym
opcja11=uimenu(opcja1,'Label','&Otwrz','CallBack','zotworz;');
opcja12=uimenu(opcja1,'Label','&Zapisz jako ...','CallBack','zzapisz');
opcja13=uimenu(opcja1,'Label','Zmie &cig','Callback','zzciag','separator','on');
opcja14=uimenu(opcja1,'Label','Zam&knij','CallBack','close all;clear;tytulowa','separator','on');
opcja2=uimenu('Label','&Wydruki');
opcja21=uimenu(opcja2,'Label','Wykresy');
opcja22=uimenu(opcja2,'Label','Tabele');
opcja3=uimenu('Label','&Pomoc');

uklad1=axes('position',[0.45 .55 .5 .36],...
            'FontName','Arial',...
	    'FontSize',8,...
	    'ButtonDownFcn','',...
	    'Visible','on',...
	    'GridLineStyle',':',...
	    'NextPlot','add',...
            'Interruptible','no');
uklad2=axes('Units','normalized','Position',[0.45 .1 .5 .36],...
            'FontName','Arial',...
	    'FontSize',8,...
            'DrawMode','normal',...
            'Visible','on',...
            'ButtonDownFcn','',...
	    'NextPlot','add',...
            'Interruptible','no');
bazowy=axes('Units','normalized','Position',[0 0 1 1],...
            'FontName','Arial',...
	    'FontSize',8,...
            'DrawMode','normal',...
            'Visible','off',...
            'ButtonDownFcn','',...
	    'NextPlot','add',...
            'Interruptible','no');
axes(uklad1);
grid on;
axes(uklad2);
grid on;
axes(bazowy);
grid off;

dy=-0.56;

% **********
% WYBOR METODY 1 ********************************************
% **********
	set(text,'string','Metoda 1','position',[.08 1+dy],'FontName','Arial','FontSize',14,'color','y');
	set(text,'string','Metoda 1','position',[.42 .97],'FontName','Arial','FontSize',12,'color','y');
	s1=uicontrol('style','popupmenu','units','normalized','position',[0.03 0.93+dy 0.19 0.035],...
		'string','Przegldu zupenego|Dychotom-go podziau|Zotego podziau|Alfa-podziau|Podziau na p|Fibonacziego|Aprok-cji kwadratowej|Pochodnej|Znaku pochodnej|Newtona',...
		'backgroundcolor','w','CallBack','zzkieru1;zzmiana1','value',s1value);

% zaznaczenie uzywanych opcji
zaznacz01=text;
	set(zaznacz01,'string','o','position',[0.01 0.323],'color','y','fontweight','bold');
zaznacz02=text;
	set(zaznacz02,'string','o','position',[0.01 0.273],'color','y','fontweight','bold');
zaznacz03=text;
	set(zaznacz03,'string','o','position',[0.01 0.223],'color','y','fontweight','bold');
zaznacz04=text;
	set(zaznacz04,'string','o','position',[0.01 0.173],'color','y','fontweight','bold');

% **********
% WYBOR METODY 2 ********************************************
% **********
	set(text,'string','Metoda 2','position',[.28 1+dy],'FontName','Arial','FontSize',14,'color','w');
	set(text,'string','Metoda 2','position',[.42 .51],'FontName','Arial','FontSize',12,'color','w');
	s2=uicontrol('style','popupmenu','units','normalized','position',[0.23 0.93+dy 0.19 0.035],...
		'string','Przegldu zupenego|Dychotom-go podziau|Zotego podziau|Alfa-podziau|Podziau na p|Fibonacziego|Aproks-cji kwadratowej|Pochodnej|Znaku pochodnej|Newtona',...
		'backgroundcolor','w','CallBack','zzkieru2;zzmiana2','value',s2value);

% zaznaczenie uzywanych opcji
zaznacz11=text;
	set(zaznacz11,'string','o','position',[0.03 0.323],'color','w','fontweight','bold');
zaznacz12=text;
	set(zaznacz12,'string','o','position',[0.03 0.273],'color','w','fontweight','bold');
zaznacz13=text;
	set(zaznacz13,'string','o','position',[0.03 0.223],'color','w','fontweight','bold');
zaznacz14=text;
	set(zaznacz14,'string','o','position',[0.03 0.173],'color','w','fontweight','bold');

	set(text,'string','Funkcja:','position',[.01 .91],'FontName','Arial','FontSize',14,'color','y');


% *********************************
% ************ PARAMETRY **********
% *********************************

	% **********************************
	% *** dolna granica przedzialu - "a"
	% **********************************
	t1=text;
	set(t1,'string','Dolna granica przedziau [a]:','position',[0.05 0.885+dy],'FontSize',12,...
		'FontName','Arial','Color','w');
	s3=uicontrol('style','edit','units','normalized','position',[0.35 0.87+dy 0.07 0.04],...
		'backgroundcolor','w','string',num2str(a),'CallBack','zzmiana');
	% **********************************
	% *** gorna granica przedzialu - "b"
	% **********************************
	t2=text;
	set(t2,'string','Grna granica przedziau [b]:','position',[0.05 0.835+dy],'FontSize',12,...
		'FontName','Arial','Color','w');
	s4=uicontrol('style','edit','units','normalized','position',[0.35 0.82+dy 0.07 0.04],...
		'backgroundcolor','w','string',num2str(b),'CallBack','zzmiana');
	% **********************************
	% *** dokladnosc obliczen - "l"
	% **********************************
	t3=text;
	set(t3,'string','Dokadno oblicze (e):','position',[0.05 0.785+dy],'FontSize',12,...
		'FontName','Arial','Color','w');
	s5=uicontrol('style','edit','units','normalized','position',[0.34 0.77+dy 0.08 0.04],...
		'backgroundcolor','w','string',num2str(l),'CallBack','zzmiana');
	% **********************************
	% *** wspolczynnik korekcji punktow
	% **********************************
	t4=text;
	set(t4,'string','Wsp. korekcji (alfa):','position',[0.05 0.735+dy],'FontSize',12,...
		'FontName','Arial','Color','w');
	s6=uicontrol('style','edit','units','normalized','position',[0.34 0.72+dy 0.08 0.04],...
		'backgroundcolor','w','string',num2str(ep),'CallBack','zzmiana');


% *******************************
% ***** GORNY WYKRES ************
% *******************************
	t5=text;
	set(t5,'string','','position',[0.55 0.97],'FontSize',12,'FontName','Arial','Color','y');
	t5a=text;
	set(t5a,'string','','position',[0.55 0.92],'FontSize',12,'FontName','Arial','Color','y');
% *******************************
% ***** DOLNY WYKRES ************
% *******************************
	t15=text;
	set(t15,'string','','position',[0.55 0.51],'FontSize',12,'FontName','Arial','Color','w');
	t15a=text;
	set(t15a,'string','','position',[0.55 0.466],'FontSize',12,'FontName','Arial','Color','w');


% ********************************
% PRZYCISKI OBLICZ ***************
% ********************************
	uicontrol('style','pushbutton','Units','normalized','position',[0.03 .08 0.19 0.04],...
		'string','Oblicz','CallBack','zzoblic1');
	uicontrol('style','pushbutton','Units','normalized','position',[0.23 .08 0.19 0.04],...
		'string','Oblicz','CallBack','zzoblic2');


% ********************************
% ************* ZOOM *************
% ********************************

% WYKRES 1
	zoom1=1;
	zoom2=1;
	uicontrol('style','pushbutton','Units','normalized','position',[0.96 0.55 0.02 0.03],...
		'string','+','CallBack','zoom1p');
	uicontrol('style','pushbutton','Units','normalized','position',[0.96 0.52 0.02 0.03],...
		'string','-','CallBack','zoom1m');

% WYKRES 2
	uicontrol('style','pushbutton','Units','normalized','position',[0.96 0.15 0.02 0.03],...
		'string','+','CallBack','zoom2p');
	uicontrol('style','pushbutton','Units','normalized','position',[0.96 0.12 0.02 0.03],...
		'string','-','CallBack','zoom2m');



tk1=text;
	set(tk1,'string','1','fontsize',10,'fontweight','bold','fontname','Arial','color','y',...
		'position',[0.96 0.60]);
tk2=text;
	set(tk2,'string','1','fontsize',10,'fontweight','bold','fontname','Arial','color','y',...
		'position',[0.96 0.2]);


% *************************************
% ******* FUNKCJA CELU ****************
% *************************************
s7=uicontrol('style','popupmenu','units','normalized','position',[0.14 0.905 0.26 0.035],...
	'string','At^4 + Bt^3 + Ct^2 + Dt + E|Att+Bsin(t)|(t-A)^4 + (t-B)^2 + Ct',...
	'backgroundcolor','w','callback','zzfunkc');

uicontrol('style','pushbutton','units','normalized','position',[0.37 0.85 0.032 0.033],...
	'string','P','callback','zzparam');

% parametry funkcji celu - wyswietlenie
text_13=text;
	set(text_13,'Units','normalized');	
	set(text_13,'FontName','Arial');	set(text_13,'color','w');
	set(text_13,'FontWeight','normal');	set(text_13,'FontSize',11);
	set(text_13,'position',[0.01 0.865]);
	set(text_13,'string',['Parametry: A=',num2str(par(1)),', B=',num2str(par(2)),', C=',num2str(par(3)),', D=',num2str(par(4)),', E=',num2str(par(5))]);


opis_y=0.75;
% opis dla METODY 1
text_METODA11=text;
	set(text_METODA11,'units','normalized');  set(text_METODA11,'fontname','Arial');
	set(text_METODA11,'color','y');		  set(text_METODA11,'fontsize',11);
	set(text_METODA11,'fontweight','bold');
	set(text_METODA11,'position',[0.01 opis_y]);
text_METODA12=text;
	set(text_METODA12,'units','normalized');  set(text_METODA12,'fontname','Arial');
	set(text_METODA12,'color','y');		  set(text_METODA12,'fontsize',11);
	set(text_METODA12,'position',[0.01 opis_y-0.03]);
text_METODA13=text;
	set(text_METODA13,'units','normalized');  set(text_METODA13,'fontname','Arial');
	set(text_METODA13,'color','y');		  set(text_METODA13,'fontsize',11);
	set(text_METODA13,'position',[0.01 opis_y-0.06]);
text_METODA14=text;
	set(text_METODA14,'units','normalized');  set(text_METODA14,'fontname','Arial');
	set(text_METODA14,'color','y');		  set(text_METODA14,'fontsize',11);
	set(text_METODA14,'position',[0.01 opis_y-0.09]);

	set(text_METODA11,'string','Metoda 1 linia 1');
	set(text_METODA12,'string','Metoda 1 linia 2');
	set(text_METODA13,'string','Metoda 1 linia 3');
	set(text_METODA14,'string','Metoda 1 linia 3');

% opis dla METODY 2
text_METODA21=text;
	set(text_METODA21,'units','normalized');  set(text_METODA21,'fontname','Arial');
	set(text_METODA21,'color','w');		  set(text_METODA21,'fontsize',11);
	set(text_METODA21,'position',[0.01 opis_y-0.14]);
	set(text_METODA21,'fontweight','bold');
text_METODA22=text;
	set(text_METODA22,'units','normalized');  set(text_METODA22,'fontname','Arial');
	set(text_METODA22,'color','w');		  set(text_METODA22,'fontsize',11);
	set(text_METODA22,'position',[0.01 opis_y-0.14-0.03]);
text_METODA23=text;
	set(text_METODA23,'units','normalized');  set(text_METODA23,'fontname','Arial');
	set(text_METODA23,'color','w');		  set(text_METODA23,'fontsize',11);
	set(text_METODA23,'position',[0.01 opis_y-0.14-0.06]);
text_METODA24=text;
	set(text_METODA24,'units','normalized');  set(text_METODA24,'fontname','Arial');
	set(text_METODA24,'color','w');		  set(text_METODA24,'fontsize',11);
	set(text_METODA24,'position',[0.01 opis_y-0.14-0.09]);

	set(text_METODA21,'string','Metoda 1 linia 1');
	set(text_METODA22,'string','Metoda 1 linia 2');
	set(text_METODA23,'string','Metoda 1 linia 3');
	set(text_METODA24,'string','Metoda 1 linia 3');
zzkieru1;
zzkieru2;




