function b = polystab(a);
%POLYSTAB Polynomial stabilization.
%	POLYSTAB(A), where A is a vector of polynomial coefficients,
%	stabilizes the polynomial with respect to the unit circle;
%	roots whose magnitudes are greater than one are reflected
%	inside the unit circle.

%	Revised 7-25-89 JNL (Handles roots at zero)
%	Copyright (c) 1985-91 by the MathWorks, Inc.

v = roots(a); i = find(v~=0);
vs = 0.5*(sign(abs(v(i))-1)+1);
v(i) = (1-vs).*v(i) + vs./conj(v(i));
b = a(1)*poly(v);

% Return only real coefficients if input was real:
if ~any(imag(a))
	b = real(b);
end
