function a = kratio(m)
%KRATIO	Utility function for use with ELLIP.
%	KRATIO is a function used to calculate the zeros of an
%	elliptic filter.  It is used with FMINS to find a
%	parameter m satisfying ellipk(m)/ellipk(1-m) = krat.

% eps(2) used to pass in global information, krat, the requested
% value for K/K'.
krat = eps(2);
% to ensure we don't call ellipk(1,1) which is inf on non-ieee machines
% and that we only call with positive m.
m = min(1,max(m,0));
if abs(m) > eps(1) & abs(m)+eps(1) < 1
	k = ellipk(1,[m,1-m]);
	r = k(1)./k(2) - krat;
elseif abs(m) <= eps(1)	% m==0
	r = -krat;
else	% m==1 => r == inf, but can't for non-ieee machines
	r = 1e20;
end
a = abs(r);
