function h = freqs(b,a,w)
%FREQS	Laplace-transform (s-domain) frequency response.  
%	H = FREQS(B,A,W) returns the complex frequency response vector H 
%	of the filter B/A:
%	                     nb-1      nb-2
%		 B(s)   b(1)s  +  b(2)s   + ... +  b(nb)
%	  H(s) = ---- = --------------------------------
%	                     na-1      na-2
%		 A(s)   a(1)s  +  a(2)s   + ... +  a(na)
%
%	given the numerator and denominator coefficients in vectors B and A. 
%	The frequency response is evaluated at the points specified in 
%	vector W.  The magnitude and phase can be graphed with:
%
%	         w = logspace(d1,d2);
%	         h = freqs(b,a,w);
%	         mag = abs(h);   phase = angle(h)*180/pi;
%	         loglog(w,mag), semilogx(w,phase)
%
%	See also LOGSPACE, POLYVAL, INVFREQS, and FREQZ.

% 	J.N. Little 6-26-86
%	Last revised 6-25-86 JNL
%	Copyright (c) 1985-91 by the MathWorks, Inc.

s = sqrt(-1)*w;
h = polyval(b,s) ./ polyval(a,s);

