function A = denf(R,na)
%DENF	Compute order NA denominator A from covariances R(0)...R(nr) using
%	the Modified Yule-Walker method.  This function used by YULEWALK.

nr = max(size(R));
Rm = toeplitz(R(na+1:nr-1),R(na+1:-1:2));
Rhs = - R(na+2:nr);
A = [1 Rhs/Rm'];

