function y = triu(x,k)
%TRIU	Upper triangle.  TRIU(X) is the upper triangular part of X.
%	TRIU(X,K) is the elements on and above the K-th diagonal of
%	X.  K = 0 is the main diagonal, K > 0  is  above  the  main
%	diagonal and K < 0 is below the main diagonal.
if nargin == 1
   k = 0;
end
[m,n] = size(x);
y = zeros(m,n);
for j = max(1,1+k):n
   i = 1:min(m,j-k);
   y(i,j) = x(i,j);
end
