function y = tril(x,k)
%TRIL	Lower triangle.  TRIL(X) is the lower triangular part of X.
%	TRIL(X,K) is  the elements on and below the  K-th  diagonal
%	of X .  K = 0  is the main diagonal,  K > 0  is  above  the
%	main diagonal and K < 0 is below the main diagonal.
if nargin == 1
   k = 0;
end
[m,n] = size(x);
y = zeros(m,n);
for i = max(1,1-k):m
   j = 1:min(n,i+k);
   y(i,j) = x(i,j);
end
