function y = std(x)
%STD	Standard deviation. For vectors, STD(x) returns the standard
%	deviation.  For matrices, STD(X) is a row vector containing
%	the standard deviation of each column. See also COV.

%	J.N. Little 4-21-85
%	Revised 5-9-88 JNL
%	Copyright (c) 1985, 1988 by the MathWorks, Inc.

%	Sample standard deviation (normalized by N-1).

[m,n] = size(x);
if (m == 1) + (n == 1)
	m = max(m,n);
	y = norm(x-sum(x)/m);
else
	avg = sum(x)/m;
	y = zeros(avg);
	for i=1:n
		y(i) = norm(x(:,i)-avg(i));
	end
end
if m == 1
	y = 0;
else 
	y = y / sqrt(m-1);
end
