function y = polyval(c,x)
%POLYVAL Polynomial evaluation.
%	If V is a vector whose elements are the coefficients of a
%	polynomial, then POLYVAL(V,s) is the value of the
%	polynomial evaluated at s.  If S is a matrix or vector,
%	the polynomial is evaluated at all points in S.
%	See POLYVALM for evaluation in a matrix sense.

%	Polynomial evaluation c(x) using Horner's method 

%	Copyright 1986-88, The MathWorks, Inc.
%	J.N. Little 4-26-86
% 	Revised 3-9-88 JNL

[m,n] = size(x);
nc = max(size(c));

if (m+n) == 2
	% Make it scream for scalar X.  Polynomial evaluation can be
	% implemented as a recursive digital filter.
	y = filter(1,[1 -x],c);
	y = y(nc);
	return
end

% Do general case where X is an array
y = zeros(m,n);
for i=1:nc
	y = x .* y + c(i) * ones(m,n);
end
