function p = polyfit(x,y,n)
% POLYFIT	POLYFIT(x,y,n) finds the coefficients of a polynomial
%		formed from the data in vector x of degree n that fits
%		the data in vector y in a least-squares sense.  

%	J.N. Little 4-21-85
%	Revised 8-23-86 JNL
%	Copyright (c) 1985, 1986 by the MathWorks, Inc.

% the regression problem is formulated in matrix format as:
%
%	y = A*P    or
%
%	      3  2  
%	y = [x  x  x  1] [p3
%			  p2
%			  p1
%			  p0]
%
% where the vector P contains the coefficients to be found.  For a
% 7th order polynomial, matrix A would be:
%
% A = [x.^7 x.^6 x.^5 x.^4 x.^3 x.^2 x ones(x)];

if any(size(x) ~= size(y))
	error('X and Y vectors must be the same size')
end
x = x(:); y = y(:);
n = n + 1;
A = zeros(max(size(x)),n);
% Construct Vandermonde matrix
for j=1:n
	A(:,j) = x.^(n-j);
end
p = (A\y).';
