function c = poly(x)
%POLY	Characteristic polynomial.
%	If A is an N by N matrix, POLY(A) is a row vector with
%	N+1 elements which are the coefficients of the
%	characteristic polynomial, DET(lambda*EYE(A) - A) .
%	If V is a vector, POLY(V) is a vector whose elements are
%	the coefficients of the polynomial whose roots are the
%	elements of V . For vectors, ROOTS and POLY are inverse
%	functions of each other, up to ordering, scaling, and
%	roundoff error.
%	ROOTS(POLY(1:20)) generates Wilkinson's famous example.

%	J.N. Little 4-21-85
%	Revised 3-17-86 JNL
%	Revised 11-6-90 CMT
%	Copyright (c) 1985, 1986 by the MathWorks, Inc.

n = size(x);
e = x;

% Characteristic polynomial (square x)
if ~sum(n == 1)
	e = eig(x);
end

if max(size(e)) == 0
	c = 1;
	return
end

% Strip infinities and throw away.
e = e( finite(e) );
n = max(size(e));

% Expand recursion formula
c = [1 zeros(1,n)];
for j=1:n
	c(2:(j+1)) = c(2:(j+1)) - e(j).*c(1:j);
end

% Force real if matrix was real.
if all(imag(x) == 0)
	c = real(c);
end
