function p = nextpow2(n)
%NEXTPOW2 Next power of two.
%	NEXTPOW2(N) returns the first P such that 2^P >= N.  It is
%	often useful for finding the nearest power of two sequence
%	length for FFT operations.
%	NEXTPOW2(X), if X is a vector, is the same as NEXTPOW2(LENGTH(X)).

% This is trickier than it might seem at first because of
% roundoff error.

i = length(n);
if i > 1
	n = length(n);
end

p = round(log(n)./log(2)) + [-1 0 1];
p = p(round(2 .^p) >= n);
p = p(1);
