function [x,y] = meshdom(x,y)
%MESHDOM  Generate X and Y arrays for 3-d plots.
%	[XX,YY] = MESHDOM(X,Y)  transforms the domain specified by vectors
%	X and Y into arrays XX and YY that can be used for the evaluation
%	of functions of two variables with 3-d mesh plots.  For example,
%	to evaluate the function  x*exp(-x^2-y^2) over the range  -2 < x < 2
%	-2 < y < 2,
%
%			[x,y] = meshdom(-2:.2:2, -2:.2:2);
%			z = x .* exp(-x.^2 - y.^2);
%			mesh(z)

% 	J.N. Little 12-2-85
%	Revised 20-May-90, LS.
%	Copyright (c) 1985, 1986, 1990 by the MathWorks, Inc.

nx = length(x);
ny = length(y);
x = x(:).';  % make sure x is a row vector
x = x(ones(ny, 1),:);
y = y(ny:-1:1); y = y(:);	% make sure y is a column vector
y = y(:,ones(1, nx));
