function K = kron(A,B)
%KRON	KRON(X,Y) is the Kronecker tensor product of X and Y.
%	The result is a large matrix formed by taking all possible
%	products between the elements of X and those of Y.   For
%	example, if X is 2 by 3, then KRON(X,Y) is
%
%	   [ X(1,1)*Y  X(1,2)*Y  X(1,3)*Y
%	     X(2,1)*Y  X(2,2)*Y  X(2,3)*Y ]

%	J.N. Little 4-21-85
%	Copyright (c) 1985-1988 by the MathWorks, Inc.

[ma,na] = size(A);
[mb,nb] = size(B);

K = zeros(ma*mb,na*nb);

if ma*na <= mb*nb
	for i = 1:ma
		ik = 1+(i-1)*mb:i*mb;
		for j = 1:na
			jk = 1+(j-1)*nb:j*nb;
			K(ik,jk) = A(i,j)*B;
		end
	end
else
	for i = 1:mb
		ik = i:mb:(ma-1)*mb+i;
		for j = 1:nb
			jk = j:nb:(na-1)*nb+j;
			K(ik,jk) = B(i,j)*A;
		end
	end
end
