function b = inverf(x)
%INVERF	Inverse Error function.
%	INVERF(X) returns the value of the inverse error function
%	for every element of X, accurate to about 1E-5.  The error
%	function is the integral of the normal probability distribution
%	function from 0 to X:
%
%	     ERF(X) = 2/sqrt(pi) integral(0,X) exp(-t^2)
%
%	See also ERF.

%	C.R. Denham 6-9-88
%	Modified 1-4-89, LS.
%	Copyright (c) 1988-89 by the MathWorks, Inc.

% References:
%	N.L. Johnson and S. Kotz, Continuous Univariate
%	Distributions - 1, John Wiley & Sons, p. 55, eq. (26).

% if x < 0
%  error('Domain is positive numbers.')
% end

% Newton-Raphson iteration on ERF.	
tol = 0.00001;
tp = 1/sqrt(2*pi);
[m,n] = size(x);
bp = ones(m,n);
b = zeros(m,n);
while any(any(abs(b-bp) > tol))
	bp = b;
	f = (erf(bp) - x)/2;
	fd = exp(-0.5*bp.*bp).*tp;
	b = bp - f./fd;
end
