function b=interp4(a,ntimes)
%INTERP4 2-D bilinear interpolation (expansion) of a matrix.
%	INTERP4(A,NTIMES) returns matrix A expanded by interleaving
%	bilinear interpolates between every element, working
%	iteratively for NTIMES (defaults to 1).  Matrix A must
%	contain at least two elements.

%  INTERP4 called with no arguments interpolates and plots
%   a matrix of random values.

%	Copyright (c) The MathWorks, Inc., 1988-89
%	Charles R. Denham

if nargin < 1      % Demonstration.
   a = rand(5,5);
   ntimes = 3;
  elseif nargin == 1
   ntimes = 1;
end

b = a;
[m,n] = size(a);
if m < 2 & n < 2, return, end

if m < 2 | n < 2
   oldm = m;
   for i = 1:ntimes
      a = b(:);
      [m,n] = size(a);
      b = zeros(2*m-1,1);
      b(1:2:2*m-1) = a;
      b(2:2:2*m-1) = 0.5 * (a(1:m-1) + a(2:m));
   end
   if oldm == 1, b = b.'; end
   return
end

for i=1:ntimes
   mm = 2*m-1; nn = 2*n-1;
   a = b; b = zeros(mm,nn);
   b(1:2:mm,1:2:nn) = a;
   c = a(:,1:n-1) + a(:,2:n);
   b(1:2:mm,2:2:nn) = 0.5 * c;
   c = b(1:2:mm-2,:) + b(3:2:mm,:);
   b(2:2:mm-1,:) = 0.5 * c;
   m = mm; n = nn;
end

if nargin < 1      % Demonstration.
   contour(b);
   title('Demonstration of INTERP4')
   xlabel('x'), ylabel('y')
end
