function y = interp1(x,ny);
%INTERP1 1-D interpolation using the FFT method.
%	Y = INTERP1(X,N) returns a length N vector Y obtained
%	by interpolation within vector X.  N must be larger than
%	the length of X.

%	The result has circular periodicity.
%	INTERP called with no arguments interpolates and plots
%	some random values.

% Copyright (c) The MathWorks, Inc., 1988
% Charles R. Denham, MathWorks, 1988.

if nargin < 1      % Demonstration.
   nx = 10;
   x= rand(nx,1);
   ny = 100;
end

[m,n] = size(x);
oldm = m;
if m == 1
   x = x.';
   [m,n] = size(x);
end
if ny <= m, error('NY must exceed length of X.'), end
i = m/2+1;
if rem(m,2) ~= 0, i = (m+1)/2; end
a = fft(x);
b = [a(1:i,:) ; zeros(ny-m,n) ; a(i+1:m,:)];
if rem(m,2) == 0
   if rem(ny,2) == 0
      b(i) = b(i)/2;
      b(i+ny-m) = b(i);
     else
      b(i)=0;
   end
end
y = ifft(b);
if oldm == 1, y = y.'; end
y = y * ny / m;
if ~any(imag(x)), y = real(y); end

if nargin < 1      % Demonstration.
   hold off
   ax = (0:(ny-1)) ./ ny; ax = nx .* ax + 1;
   plot(ax, y), hold on
   ax = (0:(nx-1)) ./ nx; ax = nx .* ax + 1;
   plot(ax, x, '*'), hold off
   title('Demonstration of INTERP1')
   xlabel('x'), ylabel('y')
end
