function y = ifft(x,nfft)
%IFFT	IFFT(X) is the inverse discrete Fourier transform of
%	vector X.   IFFT(X,N) is the N-point IFFT, where N must
%	be a power of 2.  See also FFT, FFT2, IFFT2.

%	J.N. Little 4-21-85
%	Revised 6-11-88 JNL
%	Copyright (c) 1985-88 by the MathWorks, Inc.

if nargin == 2
	y = conj(fft(conj(x),nfft));
else
	y = conj(fft(conj(x)));
end
[m,n] = size(y);
if m == 1
	m = n;
end
y = y/m;

