function gtext(string)
%GTEXT	Place text on a graph using a mouse.
%	GTEXT('string') displays the graph window, puts up a
%	cross-hair, and waits for a mouse button or keyboard key to be
%	pressed.  The cross-hair can be positioned with the mouse (or
%	with the arrow keys on some computers).  Pressing a mouse button
%	or any key writes the text string onto the graph at the selected
%	location.  See also: GINPUT

%       L. Shure, 12-01-88.
%	Revised: Charles D. Packard 3-8-89
%	Copyright (c) 1988-89 by the MathWorks, Inc.
%

if nargin ~= 1
   error('Not enough or too many input arguments.');
end
if ~isstr(string)
	error('Argument must be a string.')
end
[r,c]=size(string);

for rows=1:r
   [x,y] = ginput(1);
   text(x,y,string(rows,:))
end
