function b = gamma(a,x)
%GAMMA	Complete and incomplete Gamma functions.
%	GAMMA(A) returns the value of the complete Gamma function
%	for every element of A.
%
%	GAMMA(A,X) returns the value of the incomplete Gamma function
%	of A, integrated to limit X.  A and X must be matrices of the
%	same size or either one may be a scalar.

%	C.R. Denham 6-9-88
%	Copyright (c) 1988 by the MathWorks, Inc.

if nargin > 1
	[m,n]=size(a);
	[mm,nn]=size(x);
	if m ~= mm | n~= nn
		if m == 1 & n == 1
			a = a*ones(mm,nn);
		elseif mm == 1 & nn == 1
			x = x*ones(m,n);
		else
			error('Matrix dimensions must agree.')
		end
	end
end
b = a;
for i=1:prod(size(a))
	if nargin == 1
		b(i) = gammac(a(i));   % Complete.
	else
		b(i) = gammai(a(i),x(i)); % Incomplete.
	end
end
