function A = gallery(n)
%	Famous, and not so famous, test matrices
%	A = gallery(n) is an n-by-n matrix with some special property.
%	Only the following values of n are currently available:
%		n = 3 is badly conditioned.
%		n = 5 is an interesting eigenvalue problem.
%		n = 8 is the Rosser matrix, a classic symmetric eigenvalue
%		      problem.
%		n = 21 is Wilkinson's W21+, another eigenvalue problem.
%
%	See also: magic, hilb, invhilb, hadamard

if n == 3
   disp('A badly conditioned 3-by-3 matrix.')
   A = [ -149   -50  -154
          537   180   546
          -27    -9   -25 ];

elseif n == 5
   disp('Try to find the EXACT eigenvalues and eigenvectors.')
   A = [  -9     11    -21     63    -252
          70    -69    141   -421    1684
        -575    575  -1149   3451  -13801
        3891  -3891   7782 -23345   93365
        1024  -1024   2048  -6144   24572 ];

elseif n == 8
   disp('The Rosser matrix.')
   A  = [ 611.  196. -192.  407.   -8.  -52.  -49.   29.
          196.  899.  113. -192.  -71.  -43.   -8.  -44.
         -192.  113.  899.  196.   61.   49.    8.   52.
          407. -192.  196.  611.    8.   44.   59.  -23.
           -8.  -71.   61.    8.  411. -599.  208.  208.
          -52.  -43.   49.   44. -599.  411.  208.  208.
          -49.   -8.    8.   59.  208.  208.   99. -911.
           29.  -44.   52.  -23.  208.  208. -911.   99.  ];

elseif n == 21
   disp('Wilkinson Wn+.')
   E = diag(ones(n-1,1),1);
   m = (n-1)/2;
   A = diag(abs(-m:m)) + E + E';

else
   A = [];
end
