function [v,f,how] = fminstep(funfcn,v,f)
%FMINSTEP A function used by FMINS.  One step of the Nelder-Mead
%	simplex algorithm for minimizing a nonlinear function of
%	several variables.
%	FMINSTEP(F,v,f) starts with a simplex V consisting of n+1
%	points in R(n), so V is an n by n+1 matrix.  The corresponding
%	function values are
%	f(j) = fun(V(:,j)), j = 1:n+1, with f(1) <=  ... <= f(n+1)
%	and F = 'fun'.
%	Returns new simplex V which includes a better minimizer.
%	HOW is a string describing the type of step taken.
%	See FMINS.

%	C. Moler, 8-19-86
%	Copyright (c) 1986-88 by the MathWorks, Inc.

alpha = 1;  beta = 1/2;  gamma = 2;
[n,np1] = size(v);
vbar = mean(v(:,1:n)')';
vr = (1 + alpha)*vbar - alpha*v(:,n+1); fr = feval(funfcn,vr);
vk = vr;  fk = fr; how = 'reflect ';
if fr < f(n)
   if fr < f(1)
      ve = gamma*vr + (1-gamma)*vbar;  fe = feval(funfcn,ve);
      if fe < f(1)
         vk = ve; fk = fe;
         how = 'expand  ';
      end
   end
else
   vt = v(:,n+1); ft = f(n+1);
   if fr < ft
      vt = vr;  ft = fr;
   end
   vc = beta*vt + (1-beta)*vbar; fc = feval(funfcn,vc);
   if fc < f(n)
      vk = vc; fk = fc;
      how = 'contract';
   else
      for j = 2:n
         v(:,j) = (v(:,1) + v(:,j))/2; f(j) = feval(funfcn,v(:,j));
      end
      vk = (v(:,1) + v(:,n+1))/2; fk = feval(funfcn,vk);
      how = 'shrink  ';
   end
end
v(:,n+1) = vk;
f(n+1) = fk;
[f,j] = sort(f);
v = v(:,j);
