function f = fitfun(lam)
%	FITFUN is used by FITDEMO.  Fitfun(lam) returns the error
%	between the data and the values computed by the current
%	function of lam.  FITFUN assumes a function of the form
%
%	  y =  c(1)*exp(-lam(1)*t) + ... + c(n)*exp(-lam(n)*t)
%
%	with n linear parameters and n nonlinear parameters.

% Global Data
t = Data(:,1); y = Data(:,2);
A = zeros(length(t),length(lam));
for j = 1:size(lam)
   A(:,j) = exp(-lam(j)*t);
end
c = A\y;
z = A*c;
f = norm(z-y);

% Statements to plot progress of fitting:
plot(t,z,t,y,'o')
xt = max(t)/2;
yt = max(y)/2;
text(xt,1.1*yt,['lambda = ' num2str(lam(1)) '  ' num2str(lam(2))])
text(xt,1.0*yt,['err norm = ' num2str(f)])
