function e = expm(a)
% Matrix exponential via Taylor series.
% Scale A by power of 2 so that its norm is < 1/2 .
s = round(log(norm(a,1))/log(2)+1.5);
if s < 0, s = 0; end
a = a/2^s;

% Taylor series for exp(A)
[m,n] = size(a);
e = 0*a; f = eye(m,n); k = 1;
while norm(e+f-e,1) > 0, e = e + f; f = a*f/k; k = k+1; end

% Undo scaling by repeated squaring
for k = 1:s, e = e*e; end

