function errorbar(x, y, std)
%ERRORBAR Add error bars to a plot.
%	ERRORBAR(X,Y,E) adds error bars to an already existing plot of
%	vector X versus vector Y.  E is a vector the same length as X
%	and Y that specifies the lengths of the error bars.  The error
%	bars are each drawn a distance of E(i) above and below the
%	points in (X,Y) so that each bar is 2*E(i) long.
%	For example,
%
%	   x = 1:10;
%	   y = sin(x);
%	   e = std(y)*ones(x);
%	   plot(x,y), errorbar(x,y,e)
%
%	draws error bars of unit standard deviation.

%	L. Shure 5-17-88
%	(c) Copyright 1988, by The MathWorks, Inc.

hold on
npt = max(size(x));
if nargin == 2
	std = y;
	y = x;
	x(:) = 1:npt;
end
tee = (max(x)-min(x))/100;	% make tee .02 x-distance for error bars
xl = x - tee;
xr = x + tee;
for i = 1:npt
	if abs(std(i))
		ytop = y(i) + std(i);
		ybot = y(i) - std(i);
		plot([x(i) x(i)], [ytop ybot],'-',[xl(i) xr(i)], [ytop ytop],'-',[xl(i) xr(i)],[ybot ybot],'-')
	end
end
hold off
