function y = cond(x)
%COND	Condition number in 2-norm.  COND(X) is the  ratio  of  the
%	largest singular value of  X  to the smallest.

%	J.N. Little 11-15-85
%	Revised 3-9-87 JNL
%	Copyright (c) 1985, 1986, 1987 by the MathWorks, Inc.

if length(x) == 0  % Handle null matrix
	y = NaN;
	return
end
s = svd(x);
if any(s == 0)   % Handle singular matrix
	disp('Condition is infinite')
	y = Inf;
	return
end
y = max(s)./min(s);
