function ans = bessel(alpha,x)
%BESSEL There are four different M-files for Bessel functions.
%       BESSEL(nu,x) is the Bessel function J-sub-nu (x) for 
%       every point in array x.  The order nu must be a
%       scalar, but not necessarily an integer.  BESSEL is a
%       driver that selects BESSELN if nu is an integer and
%       BESSELA otherwise.
%
%       BESSELN(n,x) for integer order n, returns J-sub-n (x),
%       the Bessel function of the first kind.
%
%       BESSELA(nu,x) for noninteger order nu, returns J-sub-nu (x).
%       Warning: BESSELA(nu,x) may be inaccurate if both nu and x
%       are greater than 50.  See BESSELA for more details.
%
%       BESSELH(n,x) for integer order n, returns H-sub-n (x),
%       the complex Hankel function, J-sub-n (x) + i * Y-sub-n (x).
%
%	Modified Bessel functions of integer order are just the usual
%	Bessel functions evaluated with purely imaginary arguments.

%       C.B. Moler, 7-11-87, 4-20-90.
%       Copyright (c) 1987-90 by the MathWorks, Inc.

if alpha == round(alpha) & ~any(any(imag(x))) & alpha >= 0
        ans = besseln(alpha,x);
else
        if max(alpha,norm(x,inf)) > 25
                disp('Results may be inaccurate.  See BESSELA.')
        end
        ans = bessela(alpha,x);
end
