function [xo,yo] = bar(x,y)
%BAR	Bar graph.
%	BAR(Y) draws a bar graph of the elements of vector Y.
%	BAR(X,Y) draws a bar graph of the elements in vector Y at
%	the locations specified in X.  The X-values must be in
%	ascending order.  If the X-values are not evenly spaced, the
%	interval chosen is not symmetric about each data point.  Instead,
%	the bars are drawn midway between adjacent X-values.  The endpoints
%	simply adopt the internal intervals for the external ones needed.
%	[XX,YY] = BAR(X,Y) does not draw a graph, but returns vectors
%	X and Y such that PLOT(XX,YY) is the bar chart.
%	See also STAIRS and HIST.

%	C.B Moler 2-06-86
%	Modified 24-Dec-88, LS.
%	Copyright (c) 1985-88 by the MathWorks, Inc.
               
n = length(x);
if nargin == 1
	y = x;
	x = 1:n;
end
x = x(:);
y = y(:);
nn = 3*n;
yy = zeros(nn+1,1);
xx = yy;
yy(2:3:nn) = y;
yy(3:3:nn) = y;
notequal = norm(diff(diff(x)));
if ~notequal
	delta = (max(x) - min(x)) / (n-1);
	t = x(:)' - 0.5*delta;
	xx(1:3:nn) = t;
	xx(2:3:nn) = t;
	xx(3:3:nn) = t + delta;
	xx(nn+1) = xx(nn);
else	% spacing is unequal - do the best you can
	dx = diff(x);
	xx(1:3:nn+1) = [x;x(n)] - [dx(1); dx; dx(n-1)]/2;
	xx(2:3:nn) = xx(1:3:nn);
	xx(3:3:nn-3) = xx(4:3:nn-2);
	xx(nn) = x(n) + dx(n-1)/2;
	xx(nn+1) = xx(nn);
end
if nargout == 0
	plot(xx,yy)
	axy = axis;axis;
	hold on; plot([axy(1) axy(2)],[0 0]); hold off;
	if notequal
		hold on; plot(x,zeros(x),'*'),hold off;
	end
else
	xo = xx;
	yo = yy;
end
