	program testls1
c
c  There are two Fortran subroutines that you can call from your
c  programs to read and write the .MAT data files used by MATLAB:
c
c    SAVEMAT.FOR - save a matrix to disk
c    LOADMAT.FOR - load a matrix from disk
c
c  These subroutines are known to work with Microsoft Fortran
c  versions 3.0 and higher.  They are not thought to work with
c  PRO-FORT, RM, or Layhey Fortran compilers.
c
c  This file, TESTLS1.FOR, contains an example Fortran main program that
c  shows how to use subroutine SAVEMAT to save some data in a MAT-file.
c
c  See also:
c    - TESTLS2.FOR, another example main program
c    - The SAVEMAT.FOR and LOADMAT.FOR files
c    - TESTLS.C, SAVEMAT.C, and LOADMAT.C, for C-language programs
c    - LOAD in the reference section of the MATLAB User's Guide, for
c      detailed information on the file format of M-files.
c
c	Author: S.N. Bangert 5-31-85
c	Revised 1-8-88 JNL

c  20 byte header
	integer*4  type, mrows, ncols, imagf, namlen
c
c  Character string for name (length of name plus one)
	character  name(9)*1
c
c  Double precision data arrays for example
	double precision  rp(100), ip(100)
c
	integer rwflg
c
c  Fill real and imaginary parts with arbitrary data
	do 10 i=1,100
		rp(i) = i
		ip(i) = 101-i
10	continue
c
c  Open file in binary mode:
	open(unit=1,file='fortran.mat',status='new',form='binary')
c
c  Set header variables
c  IMPORTANT NOTE: The variable TYPE contains information describing what
c  computer (e.g. PC, Sun, VAX) was used.  For Sun use 1000, for a PC
c  use 0, and for a VAX, 2000.  The following is for a PC.
	type   = 0
	mrows  = 20
	ncols  = 5
	imagf  = 1
	namlen = 9 
c
c  Fill name array
	name(1) = 'y'
	name(2) = 'o'
	name(3) = 'u'
	name(4) = 'r'
	name(5) = 'n'
	name(6) = 'a'
	name(7) = 'm'
	name(8) = 'e'
	name(9) = '\0'
c
c  Write data
	call savemat(type, mrows, ncols, imagf, namlen, name, 
     1		rp, ip, 1, rwflg)
c
	close(1)
c
	stop
	end
