	subroutine savemat( type, mrows, ncols, imagf, namlen, name,
     $			rpart, ipart, lunit, wtflg )
c
c SAVEMAT - A Fortran subroutine that writes a double-precision matrix
c           to a data file in the .MAT-file format used by MATLAB.
c
c  See also:
c    - TESTLS1.FOR and TESTLS2.FOR, for examples of using SAVEMAT
c    - The LOADMAT.FOR file
c    - TESTLS.C, SAVEMAT.C, and LOADMAT.C, for C-language programs
c    - LOAD in the reference section of the MATLAB User's Guide, for
c      detailed information on the file format of M-files.
c    - Note that the LOAD/SAVE commands in MATLAB can now directly
c      read and write ASCII files.
c
c  These subroutines are known to work with Microsoft Fortran
c  versions 3.0 and higher.  They are not thought to work with
c  PRO-FORT, RM, or Layhey Fortran compilers.  A compiler
c  specific open option allows arbitrary byte streams to be
c  written.
c
c  Description of inputs:
c
c	type	- matrix type flag; considering the type flag as a
c		  decimal integer, the ones decimal place is used to
c		  indicate numeric or textual interpretation of the
c		  matrix data (0 for numeric or 1 for textual); 
c		  the 1000's decimal place is used to indicate the
c		  machine format for the matrix data (0 for Intel 80(2)86 
c		  based machines, 1 for Motorola 68000 based machines,
c		  and 2 for Vax d format). For example, A flag of 1000 indicates 
c		  numeric data in a 68000 machine format and a flag of
c		  1001 indicates textual interpretation of the 68000
c		  machine format data.
c	mrows	- number of rows in matrix
c	ncols	- number of columns in matrix
c	imagf	- imaginary flag; 0 for no imaginary part or 1 if the 
c		  data has an imaginary part
c	namlen	- number of characters in matrix name plus 1 (for zero 
c		  byte string terminator supplied by this routine)
c	name	- character array holding the matrix name. (Be sure 
c		  character array has room for the zero byte terminator)
c	rpart	- real part of matrix (mrows x ncols double precision 
c		  elements stored column wise)
c	ipart	- imaginary part of matrix (only used if imagf = 1)
c	lunit	- logical unit number of output file
c
c  Description of outputs:
c
c	wtflg	- write flag; 0 = good write, -1 = error during file write
c
c  NOTES : 
c
c	o  THE OUTPUT FILE MUST BE OPENED WITH THE FOLLOWING STATEMENT:
c           open(unit=lunit, file='file_name', form='binary')
c
c       o  Be sure that the 4 byte integer option is used when compiling
c          this routine and that SAVEMAT's integer arguments are 4 byte.
c
c	o  Be sure to close the file when there are no more
c	   matrices to be saved. 
c
c	o  You may call SAVEMAT multiple times to write multiple matrices
c	   onto the output file before closing it.
c
c  Author: S.N. Bangert 5-31-85
c  Revised 10-27-88 SNB  - Use binary open mode for efficiency
c
c  20 byte header
	integer  type, mrows, ncols, imagf, namlen
c
c  character string for name (length of name plus one)
	character  name(*)*1
c
c  double precision data arrays for example
	double precision  rpart(*), ipart(*)
c
c  output file logical unit number
	integer lunit
c
c  write flag
	integer  wtflg
c
c  zero byte needed to terminate variable name
	integer*1  zerobyte
	data zerobyte / 0 /
c
	mn =mrows*ncols
c
c  write header
	write(lunit,err=999)  type,mrows,ncols,imagf,namlen
c
c  write variable name
	write(lunit,err=999)  (name(i),i=1,namlen-1),zerobyte
c
c  write real part of variable
	write(lunit,err=999)  (rpart(i),i=1,mn)
c
c  write imaginary part of variable if any
	if (imagf .eq. 1)  write(lunit,err=999)  (ipart(i),i=1,mn)
c
c  good write
	wtflg = 0
	return
c
c  error during write
999	wtflg = -1
	return
	end
