	subroutine loadmat( type, mrows, ncols, imagf, namlen, name,
     $			rpart, ipart, lunit, rdflg )
c
c LOADMAT - A Fortran subroutine that reads a double-precision matrix
c           from a data file in the .MAT-file format used by MATLAB.
c
c  See also:
c    - TESTLS1.FOR and TESTLS2.FOR, for examples of using LOADMAT
c    - The SAVEMAT.FOR file
c    - TESTLS.C, SAVEMAT.C, and LOADMAT.C, for C-language programs
c    - LOAD in the reference section of the MATLAB User's Guide, for
c      detailed information on the file format of M-files.
c    - Note that the LOAD/SAVE commands in MATLAB can now directly
c      read and write ASCII files.
c
c  These subroutines are known to work with Microsoft Fortran
c  versions 3.0 and higher.  They are not thought to work with
c  PRO-FORT, RM, or Layhey Fortran compilers.  A compiler
c  specific open option allows arbitrary byte streams to be
c  written.
c
c  Description of inputs:
c
c	lunit	- logical unit number of input file
c
c
c  Description of outputs:
c
c	type	- matrix type flag; considering the type flag as a
c		  decimal integer the ones decimal place is used to
c		  indicate numeric or textual interpretation of the
c		  matrix data (0 for numeric or 1 for textual); 
c		  the 1000's decimal place is used to indicate the
c		  machine format for the matrix data (0 for Intel 8086 
c		  based machines, 1 for Motorola 68000 based machines,
c		  and 2 for Vax d format). A flag of 1000 indicates 
c		  numeric data in a 68000 machine format and a flag of
c		  1001 indicates textual interpretation of the 68000
c		  machine format data.
c	mrows	- number of rows in matrix
c	ncols	- number of columns in matrix
c	imagf	- imaginary flag; 0 for no imaginary part or 1 if the 
c		  data has an imaginary part
c	namlen	- number of characters in matrix name plus 1 (for zero 
c		  byte string terminator)
c	name	- character array holding the matrix name. (Be sure 
c		  character array has room for the zero byte terminator)
c	rpart	- real part of matrix (mrows x ncols double precision 
c		  elements stored column wise)
c	ipart	- imaginary part of matrix (only used if imagf = 1)
c	lunit	- logical fortran unit
c	rdflg	- read status flag; = 0 good read, = 1 end of file, 
c		  = -1 error reading file
c
c   NOTES : 
c
c	o  THE OUTPUT FILE MUST BE OPENED WITH THE FOLLOWING STATEMENT:
c              open(unit=lunit, file='file_name', form='binary')
c
c	o  Each call to this routine will read another MATLAB
c	   matrix until an error occurs or an end-of-file is reached.
c
c       o  Be sure that the 4 byte integer option is used when compiling
c          this routine and that LOADMAT's integer arguments are 4 byte.
c
c  Author: S.N. Bangert 5-31-85
c  Revised 10-27-88 SNB
c
c  20 byte header
	integer  type, mrows, ncols, imagf, namlen
c
c  character string for name (length of name plus one)
	character  name(*)*1
c
c  double precision data arrays for example
	double precision  rpart(*), ipart(*)
c
c  output file logical unit number
	integer lunit
c
c  read flag
	integer  rdflg
c
c  zero byte that follows name
	integer*1 zerobyte
c
c  read header
	read(lunit,err=998,end=999) type,mrows,ncols,imagf,namlen
c
c  read variable name
	read(lunit,err=998,end=999) (name(i),i=1,namlen-1),zerobyte
	mn = mrows*ncols
c
c  read real part of variable data
	read(lunit,err=998,end=999)  (rpart(i),i=1,mn)
c
c  read complex part of variable data if present
	if ( imagf .eq. 1 ) then 
	read(lunit,err=998,end=999)  (ipart(i),i=1,mn)
	end if
c
c set read flag to ok and return
	rdflg =0
	return
c
c error during read
998	rdflg = -1
	return
c
c  end of file
999	rdflg = 1
	return
	end
