echo on
% This demo shows how to find the zero of a function.
clc
%	A function called FZERO is used to find a zero of a function.

%	Consider a function called HUMPS(x) that we've defined in 
%	an M-file on disk,

type humps
pause	% Strike any key to continue.

%	Let's plot this function on the interval from 0 to 2,

x = 0:.02:2;
y = humps(x);
% plot(x,y)

pause	% Strike any key for plot.
plot(x,y), title('Notice the zero near x = 1.2'), pause
clc
%	To find a zero of this function near x = 1, we invoke FZERO:

% z = fzero('humps',1)

pause	% Strike any key to start iterations. 

z = fzero('humps',1,eps,1)
%	And the value above is the zero near 1.0.

pause	% Strike any key for plot.

x = 0.4:.02:1.6;
y = humps(x);
plot(x,y,z,humps(z),'o'),title('Zero of humps(x)'),grid, pause
