function worm(x, y, k)

% WORM Worm plot.
%  WORM(X,Y) displays an animated worm plot of vector X vs. Y.

% Charles R. Denham, MathWorks, 1989.

if nargin < 3, k = 10; end
if nargin < 1
   n = 100; r = 1:n;
   x = (rand(1, n) - 0.5) .* r; y = (rand(1, n) - 0.5) .* r;
   x = cumsum(x); y = cumsum(y);
end

hold off
ax = [min(x) max(x) min(y) max(y)];
axis(ax);

plot(x(1:k), y(1:k), 'r-'); hold on
if nargin < 1, title('WORM Demonstration'), end

j = k-1:k;
for i = k+1:length(x)
   j = j+1;
   plot(x(j), y(j), 'r-');
   plot(x(j-k+1), y(j-k+1), 'i-');
   plot(x(j-k+1), y(j-k+1), 'g:');
end

hold off
