function A = ratmovie(A,tol)
%RATMOVIE   Movie of the computation of the reduced row echelon form
%	with rational format output.
%       RATMOVIE(A) produces the reduced row echelon form of A.
%       RATMOVIE(A,tol) uses the given tolerance in the rank tests.
clc
home, disp('Original matrix')
R = rat(A,'s')
pause(2)
[m,n] = size(A);

% Compute the default tolerance if none was provided.
if (nargin < 2), tol = max([m,n])*eps*norm(A,'inf'); end

% Loop over the entire matrix.
i = 1;
j = 1;
k = 0;
while (i <= m) & (j <= n)
   % Find value and index of largest element in the remainder of column j.
   [p,k] = max(abs(A(i:m,j))); k = k+i-1;
   if (p <= tol)
      % The column is negligible, zero it out.
      home, disp(['column ' int2str(j) ' is negligible'])
      A(i:m,j) = zeros(m-i+1,1);
      R(i:m,(13*j-12):13*j) = rat(zeros(m-i+1,1),'s')
      j = j + 1;
   else
      if i ~= k
         % Swap i-th and k-th rows.
         home, disp(['swap rows ' int2str(i) ' and ' int2str(k) blanks(10)])
         disp(' '), disp('R = '), disp(' ')
         A([i k],:) = A([k i],:);
         R([i k],:) = rat(A([i k],:),'s');
         for r = 1:k, if r==i | r==k, disp(R(r,:)), else, disp(' '), end, end
      end
      % Divide the pivot row by the pivot element.
      home, disp(['pivot = A(' int2str(i) ',' int2str(j) ')' blanks(10)])
      disp(' '), disp('R = '), disp(' ')
      A(i,j:n) = A(i,j:n)/A(i,j);
      R(i,:) = rat(A(i,:),'s');
      for k = 1:i-1, disp(' '), end
      disp(R(i,:))
      % Subtract multiples of the pivot row from all the other rows.
      home, disp(['eliminate in column ' int2str(j) blanks(10)])
      disp(' '), disp('R = '), disp(' ')
      for k = 1:m
         if k ~= i
            A(k,j:n) = A(k,j:n) - A(k,j)*A(i,j:n);
            R(k,:) = rat(A(k,:),'s');
            disp(R(k,:))
         else
            disp(' ')
         end
      end
      i = i + 1;
      j = j + 1;
   end
   home, disp(blanks(30))
end
clc
