clc
echo on
%	The file QUAKE.MAT contains 200Hz data from the
%	October 17, 1989 Santa Cruz Mountains Earthquake.  The
%	data are courtesy Joel Yellin at the Charles F. Richter
%	Seismological Laboratory, University of California, Santa Cruz.

%	First, load the data:

load quake.mat

%	In the workspace now are four variables containing time
%	traces from an accelerometer in the Natural Sciences
%	building at UC Santa Cruz.  The accelerometer recorded the
%	mainshock of the earthquake.  The variables n, e, v refer to
%	the three directional components measured by the instrument,
%	which was aligned parallel to the fault, with its N direction
%	pointing in the direction of Sacramento.  Units are in %g.  The
%	data is uncorrected for the response of the instrument.  The t
%	variable contains a time base.

pause	% Press any key to continue...
echo off
g = 980;   % Gravitational acceleration: cm / sec / sec.
dt = 1 ./ 200; % Sample rate = 200 per second.
k = length(n);
% First break is at approximately element #1551.
i = (1:1500);
j = (1501:5000);
t = (0:length(j)-1) .* dt;

scale = g;
nacc = n(j) .* scale; eacc = e(j) .* scale; vacc = v(j) .* scale;
nacc = nacc - mean(nacc);
eacc = eacc - mean(eacc);
vacc = vacc - mean(vacc);

ii = 1:200;
worm(eacc(ii), nacc(ii))
title('Acceleration During First Second'), xlabel('East'), ylabel('North')
pause

nvel = cumsum(nacc) .* dt;
evel = cumsum(eacc) .* dt;
vvel = cumsum(vacc) .* dt;
nvel = nvel - mean(nvel);
evel = evel - mean(evel);
vvel = vvel - mean(vvel);

ndis = cumsum(nvel) .* dt;
edis = cumsum(evel) .* dt;
vdis = cumsum(vvel) .* dt;
ndis = ndis - mean(ndis);
edis = edis - mean(edis);
vdis = vdis - mean(vdis);

xlab = 'Time (s)';
ylab = 'N - E - V';

subplot(221)

a = [nacc eacc+500 vacc+1000];
%disp('Plotting Particle Acceleration...')
plot(t, a, '-'); 
title('Acceleration (cm/s/s)')
xlabel(xlab); ylabel(ylab);

b = [nvel evel+20 vvel+40];
plot(t, b, '-');
title('Velocity (cm/s)')
xlabel(xlab); ylabel(ylab);

c = [ndis edis+20 vdis+40];
plot(t, c, '-');
title('Displacement (cm)')
xlabel(xlab); ylabel(ylab);

plot(edis, ndis, '-');
hold on
k = 1:200:length(ndis);
plot(edis(k), ndis(k), 'r*');
for kk = 1:length(k)
   s = int2str(kk-1);
   text(edis(k(kk)), ndis(k(kk)), s)
end
text(0, 0, '(Time in sec)')
title('Displacement (cm)')
xlabel('East'); ylabel('North');
hold off

pause

subplot
clc
disp('We can compute the movement of a point in 3-D space')
disp('by doubly integrating the X,Y,Z accelerations.')
disp('Please wait a moment. . .');
nn = 50;
ztemp = zeros(nn+1, nn+1);
ntemp = ndis - min(ndis);
ntemp = ntemp ./ max(ntemp);
ntemp = fix(1 + nn .* ntemp);
etemp = edis - min(edis);
etemp = etemp ./ max(etemp);
etemp = fix(1 + nn .* etemp);
vtemp = vdis - min(vdis);
vtemp = vtemp ./ max(vtemp);
for k = 1:length(vtemp)
   ztemp(etemp(k), ntemp(k)) = vtemp(k);
end
%ztemp = expand(ztemp, 2, 2);
mesh(ztemp), title('The movement of a point in 3-dimensions')

