echo on
clc
%	ODE23 and ODE45 are functions for the numerical solution of
%	ordinary differential equations.  They employ automatic step
%	size Runge-Kutta-Fehlberg integration methods.  ODE23 uses a
%	simple 2nd and 3rd order pair of formulas for medium accuracy
%	and ODE45 uses a 4th and 5th order pair for higher accuracy.
%	This demo shows their use on a simple differential equation.

pause	% Strike any key to continue.
clc
%	Consider the second order differential equation known as the
%	van der Pol equation

%	          y'' + (y^2 - 1)y' + y = 0

%	where the prime ' denotes the derivative operator.  We can rewrite
%	this as a system of first order differential equations:

%	          y1' = y1(1 - y2^2) - y2
%	          y2' = y1

%	To simulate a system, we create a function M-file that returns
%	state derivatives, given state and time values.  For this
%	example, we've created a file called VDPOL.M.  Here's what it
%	looks like:
type vdpol
pause	% Strike any key to continue.
clc
%	To simulate the differential equation defined in VDPOL over the
%	interval  0 < t < 20, we invoke ODE23:

t0 = 0;
tfinal = 15;
y0 = [0 0.25]';		% Define initial conditions.

% [t,y] = ode23('vdpol',t0,tfinal,y0);

pause	% Strike any key to start ODE23 solution.

tol = 1.e-3;		% Accuracy
trace = 1;
[t,y] = ode23('vdpol',t0,tfinal,y0,tol,trace);
plot(t,y), title('van der Pol equation time history'), pause
plot(y(:,1),y(:,2)), title('van der Pol equation - phase plane plot'),pause
clc
%	We will now simulate VDPOL using ODE45, instead of ODE23.
%	ODE45 takes longer at each step, but also takes larger steps.
%	(On some computers ODE23 and or ODE45 may be hard-coded in
%	MEX-files for speed, which makes time comparisons difficult).

% [T,Y] = ode45('vdpol',t0,tfinal,y0);

pause	% Strike any key to start ODE45 solution.

[T,Y] = ode45('vdpol',t0,tfinal,y0,tol,trace);

plot(T,Y(:,1),'o',t,y(:,1),'.'), title('ODE23 and ODE45'),..
xlabel('ODE45 steps are larger than ODE23 steps'), pause
