echo on
clc
%	The classic "sombrero" or  sin(x)/x   3-d perspective surface 
%	can be created using the "mesh" command. 

%	First we form a radius matrix R that contains elements whose values
%	are the "distance" from the center of the matrix.

x = -8: .51: 8;
y = x';
x = ones(y) * x;
y = x';
R = sqrt(x.^2 + y.^2) + eps;  					x=[];y=[];

%	Now we form a matrix of  sin(r)/r and plot it using "mesh":

z = sin(R)./R;

pause % Strike any key to continue.

mesh(z), title('sin(r)/r'), pause
contour(z),title('Contour Plot'),pause
clc
%	Here is a second example, a cosine function, obtained by applying
%	the cosine to the radius matrix R:

pause % Strike any key to plot.
mesh(cos(R)), pause
