echo on
clc
%	The Fourier series expansion for a square-wave is made up of a sum
%	of odd harmonics. We can show this graphically using MATLAB.

%	We start by forming a time vector running from 0 to 10 in steps 
%	of 0.1, and taking the sine of all the points:

t = 0:.1:10;
y = sin(t);

%	Let's plot this fundamental frequency.

pause %	Strike any key for plot.

plot(t,y), pause
clc
%	Now add the third harmonic to the fundamental, and plot it:

y = sin(t) + sin(3*t)/3;

pause %	Strike any key for plot.

plot(t,y), pause
clc

%	Now use the first, third, fifth, seventh, and ninth harmonics:

y = sin(t) + sin(3*t)/3 + sin(5*t)/5 + sin(7*t)/7 + sin(9*t)/9;

pause %	Strike any key for plot.

plot(t,y), pause
clc
%	For a finale, we will go from the fundamental to the 19th harmonic,
%	creating vectors of successively more harmonics, and saving all
%	intermediate steps as rows in a matrix.

t = 0:.031:3.14;
y = zeros(10,max(size(t)));
x = zeros(t);

for k=1:2:19
	x = x + sin(k*t)/k; 
	y((k+1)/2,:) = x;
end					% Working, please wait.

%	Let's plot these successively on an overplot, showing the transition 
%	to a square wave.  Note that Gibbs' effect says that it will never 
%	really get there.

pause %	Strike any key for plot.

plot(y(1:2:9,:)'), title('The building of a square wave: Gibbs'' effect'), pause
clc
%	Now plot this as a 3-d mesh surface, showing, perhaps
%	more vividly, the transition to a square wave.

pause %	Strike any key for plot.

mesh(y), pause
clc
