% function [ Y ] = trim(S, f)
% 
% Trim data acording to given ratio
%
% S - input data
% f - trim ratio
%
% Y - output data
%

function [ Y ] = trim(S, f)

    [n, r] = size(S);
    
    d = ceil(n*f);

    Y = ones(d,r) * Inf;

    for j=1:d
        unif = ceil(random('unif',1,n));
        Y(j,:) = S(unif,:);
    end
end