% [data] = fold_data(S,k)
%
% prepares data for cross-validation
%
% S - input data
% k - number of folds
%
% data - output data

function [data] = fold_data(S,k)

    [n, r] = size(S);
    
    d = ceil(n/k);

    a = 1;
    data = ones(k,d,r) * Inf;
    for j=1:d
        for i=1:k
           data(i,j,:) = S(a,:);

           a = a + 1;
           if (a > n)
               break;
           end

        end
    end
    

end