% [ bootstrapped ] = bootstrap_data( A )
%
% bootstraps data (randomizes data)
%
% A - input data
% bootstrapped - output data (randomized)
%

function [ bootstrapped ] = bootstrap_data( A )
    
    [n, r] = size(A);
    bootstrapped = zeros(n,r);
    for i = 1:n
        unif = ceil(random('unif',1,n));
        bootstrapped(i,:) = A(unif,:);
    end

end