% [ Y ] = aggregate(y)
%
% aggregates data gathered from bootstrapping
%
% y - input data
% Y - output data
%

function [ Y ] = aggregate(y)
    

    % calculate mean value of n-2 maximmum results
    
    temp = y;
    maxes = [];
    for z = 1:size(y,1)
        [a b] = max(temp);
        [c d] = max(a);
    
        temp(b(d),:) = -Inf;
       
        maxes = [maxes, b(d)];
    end
    
    
    Y = mean(y(maxes(1:size(y,1)-2),:));

end