clear;
NNTWARN OFF;                                % turns of warnings

%% Initalization
fprintf('[INITIALIZATION]\n');

n_boots = 10;                               % number of bootstraps
epocs = 550;

S = data_load('iris.data');                 % load and prepare dataset
%S = data_load('tic-tac-toe.data');                 % load and prepare dataset
%S = data_load('shuttle.tst');                 % load and prepare dataset
[learn_set, test_set] = dziel(S,0.1);       % split dataset into two subsets

net_perf = [];                              % prepare prformance variable
nets = [];                                  % prepare network list

%% Default Classifier
fprintf('[GENERATING DEFAULT CLASSIFIER]\n');

[net, tr] = learn(learn_set, [4], {'tansig' 'tansig' 'purelin'}, epocs);
nets = cat(1,nets,net);                     % storing network in 'nets'
net_perf = cat(1,net_perf,tr);              % storing network performance data in 'net_perf' 

%% Bootstrapping
fprintf('[GENERATING BOOTSTRAP CLASSIFIERS (%d)]\n', n_boots);

for a = 1 : n_boots 
    learn_boots = bootstrap_data(learn_set); % bootstrapping samples
    fprintf('%2.d ',a);
    [net, tr] = learn(learn_set, [4], {'tansig' 'tansig' 'purelin'}, epocs);
    nets = cat(1,nets,net);                 % storing network in 'nets'
    net_perf = cat(1,net_perf,tr);          % storing network performance data in 'net_perf' 
end;
fprintf('\n')

%% Testing
fprintf('[TESTING]\n');

r = size(test_set,2);

T = test_set(:,1:r-1);                      % prepare test data (inputs)
V = test_set(:,r:r);                        % prepare test data (output)

res_norm = [];
res_bagg = [];

for i=1:size(T,1)
    t = T(i,:);                             % test case
    v = V(i);                               % valid response
    
    norm = sim(nets(1),t');
    bagg = aggregate(nets,t');
    
    [p a1] = max(norm);
    [p a2] = max(bagg);
    
    norm(v) = norm(v) - 1;
    bagg(v) = bagg(v) - 1;
    
    err1 = sum(abs( norm ));
    err2 = sum(abs( bagg ));
    
    res_norm = cat(1,res_norm,[sim(nets(1),t')' a1 err1 v]);
    res_bagg = cat(1,res_bagg,[aggregate(nets,t')' a2 err2 v]);
end;
r = size(res_norm,2);
[mean(res_norm(:,r-1)), var(res_norm(:,r-1)); mean(res_bagg(:,r-1)),var(res_bagg(:,r-1))]

%% Plotting Results
fprintf('[PLOTTING LEARNING CURVES]\n');

cla;                                        % clean plot
plot_perf(net_perf);                        % plot learning curves

